/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.io.Serializable;

public class UxSaveHierarchyExQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderDimensionUniqueName dimensionName;
    private final UxModel model;

    public UxSaveHierarchyExQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderDimensionUniqueName dimensionName, UxModel model) {
        super(meta, requestId, schemaId);
        this.dimensionName = dimensionName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)converter.convertToServerModel(queryContext, this.model);
            IOlapBuilderDimensionDef existingDimension = schema.getExistingDimension(lock, this.dimensionName);
            if (existingDimension.getHierarchy(hierarchy.getName()) != null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.HIERARCHY_NAME_DUPLICATED, new Serializable[]{hierarchy.getName()});
            }
            existingDimension.addHierarchyForUX(hierarchy);
            UxBuilderHierarchyUniqueName hierarchyName = UxBuilderHierarchyUniqueName.create(existingDimension, hierarchy);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add hierarchy: " + hierarchyName.asString());
            UxUseCase hierarchyUC = UxHierarchyQueryMeta.createUseCase(queryContext, this.schemaId, null, hierarchyName, hierarchy.withCreateLevel());
            return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, hierarchyUC));
        });
    }
}

