/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxExtraNavigationKeyId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNodeId;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxCreateHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxDeleteHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQuery;
import crazydev.iccube.ux.builder.queries.level.UxCreateLevelQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxHierarchyQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxHierarchyQueryMeta Hierarchy = new UxHierarchyQueryMeta();

    protected UxHierarchyQueryMeta() {
        super(UxConsoleConstants.QueryName.Hierarchy);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return UxUrlConstants.HELP_SCHEMA_SEMANTIC_LAYER;
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderHierarchyUniqueName name = params.getExistingHierarchyNameParameter("name");
        return new UxHierarchyQuery(this, params.getRequestId(), schemaId, name);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, UxBuilderHierarchyUniqueName name) {
        return this.createQueryUrl(schemaId).addParam("name", name.asUrlParam());
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, @Nullable UxBuilderHierarchyUniqueName prevName, UxBuilderHierarchyUniqueName name, boolean withCreateLevel) {
        return UxHierarchyQueryMeta.createUseCase(context, UxActionSetup.ALL, schemaId, prevName, name, withCreateLevel);
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxActionSetup actionSetup, UxSchemaId schemaId, @Nullable UxBuilderHierarchyUniqueName prevName, UxBuilderHierarchyUniqueName name, boolean withCreateLevel) {
        List<UxAction> actions = null;
        if (actionSetup == UxActionSetup.ALL) {
            actions = Hierarchy.createActions(context, schemaId);
            UxBuilderDimensionUniqueName dimensionUniqueName = name.getDimensionUniqueName();
            if (dimensionUniqueName != null) {
                actions.add(UxDimensionBrowseQueryMeta.createAction(context, schemaId, dimensionUniqueName));
                actions.add(UxCreateHierarchyQueryMeta.createAction(context, schemaId, dimensionUniqueName, 2));
            }
            if (withCreateLevel) {
                actions.add(UxCreateLevelQueryMeta.createAction(context, schemaId, name, 8));
            }
            actions.add(UxDeleteHierarchyQueryMeta.createAction(context, schemaId, name));
        } else if (actionSetup == UxActionSetup.NAVIGATION_TREE) {
            actions = new ArrayList<UxAction>();
            actions.add(UxCreateLevelQueryMeta.createAction(context, schemaId, name, 2));
            actions.add(UxDeleteHierarchyQueryMeta.createAction(context, schemaId, name));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = Hierarchy.createQueryUrl(schemaId, name);
        UxUseCaseBuilder builder = new UxUseCaseBuilder(context, Hierarchy, schemaId).withId(UxBuilderUseCaseName.Hierarchy, name.getHierarchyName()).withExtraNavigationKeyId(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(name))).withCaption(babylon.translate("hierarchyUC", new Serializable[]{name.getHierarchyName()})).withParentId(UxBuilderUseCaseName.SemanticLayer).withUrl(url).withActions(actions);
        if (prevName != null) {
            builder = builder.withExtraNavigationKeyId_(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(prevName)));
        }
        return builder.build(actionSetup != UxActionSetup.NONE);
    }
}

