/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyReference;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxSaveHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.tabulardata.UxBrowseTabularDataQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import org.jetbrains.annotations.Nullable;

public class UxHierarchyQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderHierarchyUniqueName name;
    @Nullable
    private UxBuilderHierarchyReference hierarchy;
    @Nullable
    private IOlapBuilderTabularDataDef hierarchyTabularData;

    public UxHierarchyQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderHierarchyUniqueName name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.hierarchy = schema.getExistingHierarchy(lock, this.name);
            this.hierarchyTabularData = schema.getTabularData(lock, this.hierarchy.dimension.getDataTableId());
            if (this.hierarchy.hierarchy.isParentChild()) {
                queryContext.setupDimensionTableUUID(this.hierarchy.dimension.getDataTableId());
            }
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, 1, lock, (Object)this.hierarchy.dimension, this.hierarchy.hierarchy, (Boolean)true);
            UxAction save = UxSaveHierarchyQueryMeta.createAction(queryContext, this.schemaId, this.name);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.hierarchy != null) {
            UxUseCase useCase = UxHierarchyQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderHierarchyUniqueName.create(this.hierarchy.dimension, this.hierarchy.hierarchy), this.hierarchy.hierarchy.withCreateLevel());
            if (useCase != null) {
                useCase.addActions(UxBrowseTabularDataQueryMeta.createAction(queryContext, this.schemaId, this.hierarchyTabularData));
            }
            reply.withUseCase(useCase);
        }
    }
}

