/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts.mappings;

import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.type.IOlapBuilderInputTypeConverter;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.ux.UxSerializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxLevelKeyPart
implements UxSerializable {
    private final String name;
    @Nullable
    private final String type;
    @Nullable
    private final String[] typeConverter;

    public UxLevelKeyPart(String name) {
        this(name, null, null);
    }

    public UxLevelKeyPart(String name, @Nullable String type, @Nullable String[] typeConverter) {
        this.name = name;
        this.type = type;
        this.typeConverter = typeConverter;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String[] getTypeConverter() {
        return this.typeConverter;
    }

    public boolean equalsType(@Nullable UxLevelKeyPart other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.type == null && other.type == null) {
            return false;
        }
        if (this.type == null || other.type == null) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            if (this.typeConverter != null && other.typeConverter != null) {
                for (int ii = 0; ii < this.typeConverter.length; ++ii) {
                    String tc = this.typeConverter[ii];
                    for (int jj = 0; jj < other.typeConverter.length; ++jj) {
                        String otc = other.typeConverter[jj];
                        if (!tc.equals(otc)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static UxLevelKeyPart create(OlapBabylonService babylon, boolean isTimeWizard, @Nullable IOlapBuilderTabularDataDef table, OlapBuilderDataColumnRef columnRef) {
        List columns;
        String name = columnRef.getName();
        if (table != null && (columns = table.getSelectedColumns()) != null) {
            for (IOlapBuilderDataColumnDef column : columns) {
                String columnName = column.getName();
                if (columnName == null || !name.equals(columnName)) continue;
                return UxLevelKeyPart.create(babylon, isTimeWizard, column);
            }
        }
        return new UxLevelKeyPart(name);
    }

    public static UxLevelKeyPart create(OlapBabylonService babylon, boolean isTimeWizard, IOlapBuilderDataColumnDef column) {
        String type = null;
        String[] typeConverter = null;
        OlapBuilderInputType iType = column.getType();
        if (iType != null) {
            type = babylon.translateEnum(OlapBuilderInputType.class, iType.name());
            if (!isTimeWizard) {
                IOlapBuilderInputTypeConverter iTypeConverter = iType.getTypeConverter();
                typeConverter = new String[]{iTypeConverter.getType().getName()};
            } else {
                typeConverter = new String[]{OlapBuilderInputType.DATE.getTypeConverter().getType().getName(), OlapBuilderInputType.DATETIME.getTypeConverter().getType().getName()};
            }
        }
        return new UxLevelKeyPart(column.getName(), type, typeConverter);
    }

    public String toString() {
        return this.name;
    }
}

