/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts.create;

import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderCreateMeasureGroupWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.facts.create.UxCreateMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.create.UxSaveMeasureGroupWizardQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.create.UxValidateMeasureGroupWizardQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefReplyPayload;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefStep;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardLastStep;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxCreateMeasureGroupQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final String cubeName;

    public UxCreateMeasureGroupQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable String cubeName) {
        super(meta, requestId, schemaId);
        this.cubeName = cubeName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.setModelTypesSetupInfoForMeasureGroup(queryContext, lock, schema, true, true, false);
            UxBuilderCreateMeasureGroupWizard wizard = UxBuilderCreateMeasureGroupWizard.create((String)this.cubeName);
            UxWizardDef wizardDef = this.setupWizardDef(queryContext, wizard);
            return UxReply.success(new UxWizardDefReplyPayload(wizardDef));
        });
    }

    private UxWizardDef setupWizardDef(UxQueryContext context, UxBuilderCreateMeasureGroupWizard wizard) {
        UxBabylonService babylon = context.getUxBabylonService();
        String useCaseTitle = babylon.translateUseCaseCaption(UxBuilderUseCaseName.CreateMeasureGroup.name(), new Serializable[0]);
        ArrayList<UxWizardDefStep> stepsUI = new ArrayList<UxWizardDefStep>();
        for (UxBuilderWizardStep step : wizard.getSteps()) {
            stepsUI.add(this.setupWizardStepUI(context, step));
        }
        String captionAllDoneC = babylon.translate("wizard.createMeasureGroup.allDoneC", new Serializable[0]);
        String captionAllDoneI = babylon.translate("wizard.createMeasureGroup.allDoneI", new Serializable[0]);
        UxAction create = UxSaveMeasureGroupWizardQueryMeta.createAction(context, this.schemaId);
        UxWizardLastStep lastStep = new UxWizardLastStep(captionAllDoneC, captionAllDoneI, create);
        UxAction validate = UxValidateMeasureGroupWizardQueryMeta.createAction(context, this.schemaId);
        return new UxWizardDef(useCaseTitle, wizard.getProps(), stepsUI, lastStep, validate);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxCreateMeasureGroupQueryMeta.createUseCase(queryContext, this.schemaId, this.cubeName));
    }
}

