/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveMeasureGroupQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderMeasureGroupUniqueName measureGroupName;
    private final UxModel model;

    public UxSaveMeasureGroupQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderMeasureGroupUniqueName measureGroupName, UxModel model) {
        super(meta, requestId, schemaId);
        this.measureGroupName = measureGroupName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            this.setModelTypesSetupInfoForMeasureGroup(queryContext, lock, schema, true, false, false);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderBaseFactsDef measureGroup = (IOlapBuilderBaseFactsDef)converter.convertToServerModel(queryContext, this.model);
            if (!measureGroup.getUUID().equals(this.measureGroupName.asUUID())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_UUID_MISMATCH, (Serializable[])new Serializable[]{this.measureGroupName.asUUID(), measureGroup.getUUID()}));
            }
            if (this.model.isPersistent()) {
                if (!this.measureGroupName.getMeasureGroupName().equals(measureGroup.getName())) {
                    UxBuilderMeasureGroupReference existingMeasureGroup = schema.renameMeasureGroup(lock, this.measureGroupName, measureGroup.getMeasureGroupName());
                    converter.update(existingMeasureGroup.measureGroup, measureGroup);
                    continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxMeasureGroupQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderMeasureGroupUniqueName.create(existingMeasureGroup.cube, existingMeasureGroup.measureGroup)));
                    operation = "rename/edit measure group: " + this.measureGroupName.asString() + " into: " + measureGroup.getMeasureGroupName();
                } else {
                    UxBuilderMeasureGroupReference existingMeasureGroup = schema.getExistingMeasureGroup(lock, this.measureGroupName);
                    converter.update(existingMeasureGroup.measureGroup, measureGroup);
                    continuation = null;
                    operation = "edit measure group: " + this.measureGroupName.asString();
                }
            } else {
                schema.insertMeasureGroup(lock, measureGroup);
                continuation = null;
                operation = "add measure group: " + this.measureGroupName.asString();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

