/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxMoveMeasureGroupQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final String info;
    private final UxBuilderMeasureGroupUniqueName measureGroupName;
    private final String cubeName;
    private final String newCubeName;

    public UxMoveMeasureGroupQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String info, UxSchemaId schemaId, UxBuilderMeasureGroupUniqueName measureGroupName, String cubeName, String newCubeName) {
        super(meta, requestId, schemaId);
        this.info = info;
        this.measureGroupName = measureGroupName;
        this.cubeName = cubeName;
        this.newCubeName = newCubeName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderMeasureGroupReference movedMeasureGroup = schema.moveMeasureGroup(lock, this.measureGroupName, this.cubeName, this.newCubeName);
            if (movedMeasureGroup == null) {
                return UxReply.actionSuccess();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "move measure group: " + this.measureGroupName.asString() + " to: " + this.newCubeName);
            UxActionContinuation continuation = null;
            if (!"table".equals(this.info)) {
                UxBuilderMeasureGroupUniqueName factsName = UxBuilderMeasureGroupUniqueName.create(movedMeasureGroup.cube, movedMeasureGroup.measureGroup);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxMeasureGroupQueryMeta.createUseCase(queryContext, this.schemaId, null, factsName));
            }
            return UxReply.actionSuccess(continuation);
        });
    }
}

