/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts;

import crazydev.common.utils.CdMutableInt;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderUniqueNameError;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxFactsLinksOverviewQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxFactsLinksOverviewReplyPayload;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UxFactsLinksOverviewQuery
extends UxSchemaBuilderQuery {
    public UxFactsLinksOverviewQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        try {
            return this.executeQueryForPersistentSchemaUnsafe(queryContext);
        }
        catch (UxBuilderUniqueNameError error) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)"[ux.builder] unexpected error", (Throwable)error);
            UxBabylonService babylon = queryContext.getUxBabylonService();
            String param = babylon.translateActionCaption(UxFactsLinksOverviewQueryMeta.FactsLinksOverview.queryName().name(), new Serializable[0]);
            String information = babylon.translate("builder.linksOverviewSetupError", new Serializable[]{param});
            return UxReply.error(information);
        }
    }

    private UxReply executeQueryForPersistentSchemaUnsafe(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxFactsLinksOverviewReplyPayload payload = UxFactsLinksOverviewQuery.createLinksOverview(queryContext, lock, this.schemaId, schema);
            return UxReply.success(payload);
        });
    }

    protected static UxFactsLinksOverviewReplyPayload createLinksOverview(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxSchemaId schemaId, UxBuilderSchema schema) {
        ArrayList dimensions = new ArrayList();
        HashMap dimensionPositions = new HashMap();
        schema.forEachDimension(lock, dimension -> {
            dimensionPositions.put(dimension.getId(), dimensions.size());
            dimensions.add(dimension);
        });
        ArrayList measureGroupReferences = new ArrayList();
        ArrayList<String> measureGroupNames = new ArrayList<String>();
        schema.forEachSortedMeasureGroups(lock, facts -> {
            if (facts.measureGroup instanceof OlapBuilderFacts) {
                measureGroupReferences.add(facts);
                measureGroupNames.add(facts.getMeasureGroupName());
            }
        });
        UxFactsLinksOverviewReplyPayload.Type[][] types = new UxFactsLinksOverviewReplyPayload.Type[dimensions.size()][];
        for (int dd = 0; dd < dimensions.size(); ++dd) {
            types[dd] = new UxFactsLinksOverviewReplyPayload.Type[measureGroupNames.size()];
        }
        OlapBabylonService babylon = queryContext.getOlapBabylonService();
        CdMutableInt gg = new CdMutableInt(0);
        schema.forEachSortedMeasureGroups(lock, facts -> {
            if (facts.measureGroup instanceof OlapBuilderFacts) {
                List links = ((OlapBuilderFacts)facts.measureGroup).getLinks();
                for (OlapBuilderLinkXmlDefinition link : links) {
                    Integer dimensionPosition = (Integer)dimensionPositions.get(link.getDimensionId());
                    if (dimensionPosition == null) continue;
                    OlapBuilderDataViewLinksType type = link.getLink().getType();
                    types[dimensionPosition.intValue()][gg.value] = new UxFactsLinksOverviewReplyPayload.Type(type.name(), babylon.translateEnum(OlapBuilderDataViewLinksType.class, type.name()));
                }
                ++gg.value;
            }
        });
        ArrayList<UxUseCase> measureGroupUCs = new ArrayList<UxUseCase>();
        ArrayList<String> measureGroupCubeNames = new ArrayList<String>();
        for (UxBuilderMeasureGroupReference measureGroupReference : measureGroupReferences) {
            UxBuilderMeasureGroupUniqueName factsName = UxBuilderMeasureGroupUniqueName.create(measureGroupReference.cube, measureGroupReference.measureGroup);
            measureGroupUCs.add(UxMeasureGroupQueryMeta.createUseCase(queryContext, UxActionSetup.NONE, schemaId, null, factsName));
            measureGroupCubeNames.add(measureGroupReference.cube.getName());
        }
        ArrayList<UxUseCase> dimensionUCs = new ArrayList<UxUseCase>();
        for (int ii = 0; ii < dimensions.size(); ++ii) {
            IOlapBuilderDimensionDef dimension2 = (IOlapBuilderDimensionDef)dimensions.get(ii);
            String dimensionName = dimension2.getName();
            boolean dimensionWithCreateHierarchy = dimension2.withCreateHierarchy();
            dimensionUCs.add(UxDimensionQueryMeta.createUseCase(queryContext, UxActionSetup.NONE, schemaId, null, UxBuilderDimensionUniqueName.create(dimension2), dimensionWithCreateHierarchy));
        }
        ArrayList<String> dimensionNames = new ArrayList<String>();
        for (IOlapBuilderDimensionDef dimension3 : dimensions) {
            dimensionNames.add(dimension3.getName());
        }
        UxFactsLinksOverviewReplyPayload payload = new UxFactsLinksOverviewReplyPayload(measureGroupNames, measureGroupUCs, measureGroupCubeNames, dimensionNames, dimensionUCs, types);
        return payload;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.FactsLinksOverview, this.schemaId));
    }
}

