/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDuplicateDimensionQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final String info;
    private final UxBuilderDimensionUniqueName dimensionName;
    private final String newDimensionName;

    public UxDuplicateDimensionQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String info, UxSchemaId schemaId, UxBuilderDimensionUniqueName dimensionName, String newDimensionName) {
        super(meta, requestId, schemaId);
        this.info = info;
        this.dimensionName = dimensionName;
        this.newDimensionName = newDimensionName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDimensionDef duplicatedDimension;
            IOlapBuilderDimensionDef dimension = schema.getExistingDimension(lock, this.dimensionName);
            try {
                OlapEngineComponent engine = queryContext.getOlapEngineComponent();
                OlapBuilderMetaInformationRepository metaInformation = engine.getBuilderMetaInformationRepository();
                duplicatedDimension = UxBuilderSchemaService.duplicateDefinition(metaInformation, dimension);
                this.setupDuplicatedDimension(lock, schema, dimension, duplicatedDimension);
                schema.insertDimension(lock, duplicatedDimension);
            }
            catch (JAXBException | IOException ex) {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] duplicate dimension [" + this.dimensionName.asString() + "] error"), ex);
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_DIMENSION_DUPLICATE, (Serializable[])new Serializable[]{this.dimensionName.asString(), ex.getMessage()}));
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "duplicate dimension: " + this.dimensionName.asString());
            UxActionContinuation continuation = null;
            if (!"table".equals(this.info)) {
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDimensionQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderDimensionUniqueName.create(duplicatedDimension), duplicatedDimension.withCreateHierarchy()));
            }
            return UxReply.actionSuccess(continuation);
        });
    }

    private void setupDuplicatedDimension(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDimensionDef dimension, IOlapBuilderDimensionDef duplicatedDimension) {
        duplicatedDimension.resetId();
        Object duplicatedDimensionName = this.newDimensionName;
        int count = 1;
        while (schema.hasDimension(lock, (String)duplicatedDimensionName)) {
            duplicatedDimensionName = this.newDimensionName + " " + count;
            ++count;
        }
        duplicatedDimension.setName((String)duplicatedDimensionName);
        String dimensionName = dimension.getName();
        List hierarchies = duplicatedDimension.getHierarchies();
        for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
            hierarchy.setName(hierarchy.getName().replace(dimensionName, (CharSequence)duplicatedDimensionName));
            for (IOlapBuilderHierarchyLevelDef level : hierarchy.getLevels()) {
                level.setName(level.getName().replace(dimensionName, (CharSequence)duplicatedDimensionName));
            }
        }
    }
}

