/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxSaveDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.tabulardata.UxBrowseTabularDataQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import org.jetbrains.annotations.Nullable;

public class UxDimensionQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderDimensionUniqueName name;
    @Nullable
    private IOlapBuilderDimensionDef dimension;
    @Nullable
    private IOlapBuilderTabularDataDef dimensionTabularData;

    public UxDimensionQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderDimensionUniqueName name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.dimension = schema.getExistingDimension(lock, this.name);
            this.dimensionTabularData = schema.getTabularData(lock, this.dimension.getDataTableId());
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, 1, lock, (Object)schema, this.dimension, (Boolean)true);
            UxAction save = UxSaveDimensionQueryMeta.createAction(queryContext, this.schemaId, this.name);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.dimension != null) {
            UxUseCase useCase = UxDimensionQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderDimensionUniqueName.create(this.dimension), this.dimension.withCreateHierarchy());
            if (useCase != null) {
                useCase.addActions(UxBrowseTabularDataQueryMeta.createAction(queryContext, this.schemaId, this.dimensionTabularData));
            }
            reply.withUseCase(useCase);
        }
    }
}

