/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreePathTreeNodeIdentifier;
import crazydev.iccube.gwt.server.requesthandler.schemabrowser.LazyTreeSchemaBrowserCommand;
import crazydev.iccube.gwt.server.requesthandler.schemabrowser.LazyTreeSchemaBrowserPrefetchCommand;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.command.GwtSchemaBrowserLazyTreeQuery;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.model.GwtSchemaBrowserTreeInfoModel;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxLazyTreeStatus;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.queries.browser.UxBrowseSchemaQuery;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingNode;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingTree;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBrowseSchemaDimensionQuery
extends UxSchemaBuilderQuery {
    private final String schemaDimensionName;
    private final String treeId;
    @Nullable
    private final List<Integer> nodeId;
    @Nullable
    private final List<Integer> moreParentNodeId;
    @Nullable
    private final Integer moreParentPos;

    protected UxBrowseSchemaDimensionQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String schemaDimensionName, String treeId, @Nullable List<Integer> nodeId, @Nullable List<Integer> moreParentNodeId, @Nullable Integer moreParentPos) {
        super(meta, requestId, schemaId);
        this.schemaDimensionName = schemaDimensionName;
        this.treeId = treeId;
        this.nodeId = nodeId;
        this.moreParentNodeId = moreParentNodeId;
        this.moreParentPos = moreParentPos;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        IcCubeServerSessionContext sessionContext = queryContext.getSessionContext();
        OlapSchema fakeSchema = (OlapSchema)sessionContext.getFromCache(new IcCubeServerSessionContext.SoftKey(this.treeId));
        if (fakeSchema == null) {
            return UxReply.actionSuccess(new UxSchemaBrowsingTree(UxLazyTreeStatus.OUT_OF_SYNC, this.treeId, this.nodeId, null));
        }
        UxSchemaBrowsingTree tree = this.moreParentNodeId != null ? this.doExecuteForMoreNode(queryContext, fakeSchema) : UxBrowseSchemaDimensionQuery.fetchTree(queryContext, fakeSchema, this.treeId, this.schemaDimensionName, this.nodeId);
        return UxReply.actionSuccess(tree);
    }

    static UxSchemaBrowsingTree fetchTree(UxQueryContext queryContext, OlapSchema fakeSchema, String treeId, String schemaDimensionName, @Nullable List<Integer> nodeId) {
        GwtSchemaBrowserTreeInfoModel tree;
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        GwtLazyTreePathTreeNodeIdentifier parentNodeId = new GwtLazyTreePathTreeNodeIdentifier(schemaDimensionName, nodeId != null && !nodeId.isEmpty() ? CdArrayUtils.toIntArray(nodeId) : null);
        GwtSchemaBrowserLazyTreeQuery serverQuery = new GwtSchemaBrowserLazyTreeQuery(treeId, "n/a", parentNodeId, schemaDimensionName);
        int maxChildrenCount = serverRequestContext.getServerProperties().getMaxChildrenCountForSchemaBrowser();
        String engineUID = fakeSchema.getUuid();
        List<OlapSchema> schemas = Collections.singletonList(fakeSchema);
        if (parentNodeId.getPathPositions() == null) {
            cmd = new LazyTreeSchemaBrowserPrefetchCommand((IcCubeServerRequestContext)serverRequestContext, maxChildrenCount, serverQuery, engineUID, schemas, true);
            tree = (GwtSchemaBrowserTreeInfoModel)cmd.call();
        } else {
            cmd = new LazyTreeSchemaBrowserCommand(serverRequestContext, maxChildrenCount, serverQuery, engineUID, schemas);
            tree = (GwtSchemaBrowserTreeInfoModel)cmd.call();
        }
        List<UxSchemaBrowsingNode> nodes = UxBrowseSchemaQuery.asNodesForDimensionBrowsing(-1, tree.getNodeModels());
        return new UxSchemaBrowsingTree(tree.isOutOfSync() ? UxLazyTreeStatus.OUT_OF_SYNC : null, tree.getServerTreeUId(), nodeId, nodes);
    }

    private UxSchemaBrowsingTree doExecuteForMoreNode(UxQueryContext queryContext, OlapSchema fakeSchema) {
        if (this.moreParentNodeId == null || this.moreParentNodeId.isEmpty() || this.moreParentPos == null) {
            return new UxSchemaBrowsingTree(null, this.treeId, this.nodeId, null);
        }
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        GwtLazyTreePathTreeNodeIdentifier parentNodeId = new GwtLazyTreePathTreeNodeIdentifier(this.schemaDimensionName, CdArrayUtils.toIntArray(this.moreParentNodeId));
        GwtSchemaBrowserLazyTreeQuery serverQuery = new GwtSchemaBrowserLazyTreeQuery(this.treeId, "n/a", parentNodeId, this.schemaDimensionName);
        int maxChildrenCount = serverRequestContext.getServerProperties().getMaxChildrenCountForSchemaBrowser();
        String engineUID = fakeSchema.getUuid();
        List<OlapSchema> schemas = Collections.singletonList(fakeSchema);
        LazyTreeSchemaBrowserCommand cmd = new LazyTreeSchemaBrowserCommand(serverRequestContext, this.moreParentPos, maxChildrenCount, serverQuery, engineUID, schemas);
        GwtSchemaBrowserTreeInfoModel tree = (GwtSchemaBrowserTreeInfoModel)cmd.call();
        List<UxSchemaBrowsingNode> nodes = UxBrowseSchemaQuery.asNodesForDimensionBrowsing(this.moreParentPos, tree.getNodeModels());
        return new UxSchemaBrowsingTree(tree.isOutOfSync() ? UxLazyTreeStatus.OUT_OF_SYNC : null, tree.getServerTreeUId(), this.nodeId, nodes);
    }
}

