/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview.create;

import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.ux.meta.dataview.wizard.UxBuilderCreateDataViewWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.dataview.UxSaveDataViewQuery;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveDataViewWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;

    public UxSaveDataViewWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        int revNumber = -1;
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderCreateDataViewWizard wizard = UxWizardDef.setupCreateDataViewWizardFromJson(queryContext, this.props, -1, this.stepDefs, this.stepModels);
            OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
            this.setModelTypesSetupInfoForDataView(queryContext, lock, schema, true);
            IOlapBuilderDataViewDef createdView = wizard.getCreatedViewFromUI();
            if (createdView != null) {
                UxReply error = UxSaveDataViewQuery.compile(queryContext, lock, schema, null, createdView);
                if (error != null) {
                    return error;
                }
                OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)false, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)createdView);
                schema.insertDataView(lock, createdView);
            } else {
                errorManager.addError((CdErrorCode)OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"missing wizard view"});
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add view: " + (createdView != null ? createdView.getName() : "n/a"));
            UxActionContinuation continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, queryContext.getUseCase(UxBuilderUseCaseName.DataViews, this.schemaId));
            return UxReply.actionSuccess(continuation);
        });
    }
}

