/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.view.javasimple.OlapBuilderBaseSimpleJavaDataView;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveDataViewQuery
extends UxSchemaBuilderQuery {
    private final String viewName;
    private final UxModel model;

    public UxSaveDataViewQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName, UxModel model) {
        super(meta, requestId, schemaId);
        this.viewName = viewName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderDataViewDef view = (IOlapBuilderDataViewDef)converter.convertToServerModel(queryContext, this.model);
            UxReply error = UxSaveDataViewQuery.compile(queryContext, lock, schema, this.viewName, view);
            if (error != null) {
                return error;
            }
            if (this.model.isPersistent()) {
                if (!this.viewName.equals(view.getName())) {
                    IOlapBuilderDataViewDef existingView = schema.renameDataView(lock, this.viewName, view.getName());
                    converter.update(existingView, view);
                    continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataViewQueryMeta.createUseCase(queryContext, this.schemaId, schema.getName(), null, view.getName(), view.getHelpUrl()));
                    operation = "rename/edit view: " + this.viewName + " into: " + view.getName();
                } else {
                    IOlapBuilderDataViewDef existingView = schema.getDataViewByName(lock, view.getName());
                    if (existingView == null) {
                        return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"view", view.getName()}));
                    }
                    converter.update(existingView, view);
                    continuation = null;
                    operation = "edit view: " + view.getName();
                }
            } else {
                OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)false, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)view);
                schema.insertDataView(lock, view);
                continuation = null;
                operation = "add view: " + view.getName();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }

    public static UxReply compile(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable String existingViewName, IOlapBuilderDataViewDef view) {
        if (view instanceof OlapBuilderBaseSimpleJavaDataView) {
            OlapBuilderBaseSimpleJavaDataView java = (OlapBuilderBaseSimpleJavaDataView)view;
            if (!UxSaveDataViewQuery.needsRecompile(queryContext, lock, schema, existingViewName, java)) {
                return null;
            }
            try {
                Object ignored = java.getOrCreateInstance();
                return null;
            }
            catch (OlapBuilderErrorException ex) {
                OlapLoggers.BUILDER.error((Object)("[java] view [" + view.getName() + "] compilation error"), (Throwable)ex);
                OlapBuilderError error = ex.getError();
                UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
                return UxReply.validationErrors(validation);
            }
            catch (Exception ex) {
                OlapLoggers.BUILDER.error((Object)("[java] view [" + view.getName() + "] compilation error"), (Throwable)ex);
                String message = UxSaveDataViewQuery.extractErrorMessage(ex);
                OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.JAVA_VIEW_ERROR, new Serializable[]{view.getName(), message});
                UxValidationResult validation = UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), (CdError)error);
                return UxReply.validationErrors(validation);
            }
        }
        return null;
    }

    private static boolean needsRecompile(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable String existingViewName, OlapBuilderBaseSimpleJavaDataView view) {
        IOlapBuilderDataViewDef existingView;
        if (existingViewName != null && (existingView = schema.getDataViewByName(lock, existingViewName)) instanceof OlapBuilderBaseSimpleJavaDataView) {
            OlapBuilderBaseSimpleJavaDataView javaE = (OlapBuilderBaseSimpleJavaDataView)existingView;
            return javaE.needsRecompile(view.getJavaCode());
        }
        return true;
    }

    private static String extractErrorMessage(Exception ex) {
        try {
            String message = ex.getMessage();
            return CdStringUtils.isNotNullAndNotBlank((String)message) ? message : ex.getClass().getSimpleName();
        }
        catch (Exception ignored) {
            return ex.getMessage();
        }
    }
}

