/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxRefreshDataViewColumnsQuery
extends UxSchemaBuilderQuery {
    private final String viewName;

    public UxRefreshDataViewColumnsQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName) {
        super(meta, requestId, schemaId);
        this.viewName = viewName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataViewDef table = schema.getDataViewByName(lock, this.viewName);
            if (table == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"view", this.viewName}));
            }
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)false, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)table);
            return UxReply.actionSuccess();
        });
    }
}

