/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dataview;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaUsageHelper;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQuery;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxSaveDataViewQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataViewQuery
extends UxSchemaBuilderQuery {
    private final String viewName;
    @Nullable
    private String viewHelpUrl;
    @Nullable
    private String schemaName;
    @Nullable
    private String uuid;

    public UxDataViewQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName) {
        super(meta, requestId, schemaId);
        this.viewName = viewName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.schemaName = schema.getName();
            IOlapBuilderDataViewDef table = schema.getDataViewByName(lock, this.viewName);
            if (table == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"view", this.viewName}));
            }
            this.viewHelpUrl = table.getHelpUrl();
            this.uuid = table.getId();
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)false, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)table);
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, schema, table, true);
            List<IOlapBuilderUsedByDef> usages = UxBuilderSchemaUsageHelper.getUsageAllViews(lock, schema, List.of(table)).getUsedBy(table.getId());
            UxDataTableQuery.attachUsedByInformation(queryContext, this.schemaId, model, usages);
            UxAction save = UxSaveDataViewQueryMeta.createAction(queryContext, this.schemaId, schema.getName(), table.getId(), this.viewName, this.viewHelpUrl);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxDataViewQueryMeta.createUseCase(queryContext, this.schemaId, this.schemaName, this.uuid, this.viewName, this.viewHelpUrl));
    }
}

