/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.refresh;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxTableRefresh;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataSourceRefresh
implements UxSerializable {
    private final String tableCaption;
    private final String dataSourceName;
    private final List<UxTableRefresh> tables;
    @Nullable
    private final String changedPersistency;

    private UxDataSourceRefresh(String tableCaption, String dataSourceName, List<UxTableRefresh> tables, @Nullable String changedPersistency) {
        this.tableCaption = tableCaption;
        this.dataSourceName = dataSourceName;
        this.tables = tables;
        this.changedPersistency = changedPersistency;
    }

    public static UxDataSourceRefresh create(UxBabylonService babylon, String dataSourceName, UxTableRefresh table, boolean changedPersistency) {
        return UxDataSourceRefresh.create(babylon, dataSourceName, table == null ? Collections.emptyList() : Collections.singletonList(table), changedPersistency);
    }

    public static UxDataSourceRefresh create(UxBabylonService babylon, String dataSourceName, List<UxTableRefresh> tables, boolean changedPersistency) {
        String caption = babylon.translate("refresh_tableCaption", new Serializable[0]);
        String changedPersistencyS = changedPersistency ? babylon.translate("refresh_datasource_cache", new Serializable[]{dataSourceName}) : null;
        return new UxDataSourceRefresh(caption, dataSourceName, tables, changedPersistencyS);
    }

    public boolean isUpdated() {
        if (this.changedPersistency != null) {
            return true;
        }
        for (UxTableRefresh table : this.tables) {
            if (!table.isUpdated()) continue;
            return true;
        }
        return false;
    }

    public boolean hasError() {
        for (UxTableRefresh table : this.tables) {
            if (!table.hasError()) continue;
            return true;
        }
        return false;
    }
}

