/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.modeltypes.plugin;

import crazydev.common.property.CdProperty;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.UxBuilderAbstractDataTableModelType;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.field.UxFieldEditorMeta;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.field.UxFieldTypeInfo;
import crazydev.iccube.ux.common.model.UxModelTypeSetupInfo;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBuilderPluginDataTableModelType<DT extends OlapBuilderBaseDataTable>
extends UxBuilderAbstractDataTableModelType<DT> {
    private final List<CdProperty> serverProperties;

    public UxBuilderPluginDataTableModelType(Class<DT> clazz, List<CdProperty> serverProperties) {
        super(clazz.getSimpleName(), clazz);
        this.serverProperties = serverProperties;
    }

    @Override
    protected String getPrefixForLocalization() {
        return this.getServerModelClass().getSimpleName();
    }

    @Override
    protected void addRegularProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable DT model) {
        super.addRegularProperties(context, modelOwner, model);
        UxBabylonService babylon = context.getUxBabylonService();
        for (CdProperty serverProperty : this.serverProperties) {
            if (serverProperty.isForIncrLoad() || serverProperty.isForPartitioning()) continue;
            this.setupProperty(context, "group.tableProps", serverProperty, modelOwner, model);
        }
    }

    @Override
    protected void addIncrLoadProperties(UxQueryContext context, @Nullable DT model) {
        super.addIncrLoadProperties(context, model);
        UxModelTypeSetupInfo setup = context.getModelTypeSetupInfo();
        for (CdProperty serverProperty : this.serverProperties) {
            if (!serverProperty.isForIncrLoad() || setup == null || !setup.is("INCR_LOAD")) continue;
            this.setupProperty(context, "group.tableIncrLoad", serverProperty);
        }
    }

    @Override
    protected void addPartitioningProperties(UxQueryContext context, @Nullable DT model) {
        super.addPartitioningProperties(context, model);
        UxModelTypeSetupInfo setup = context.getModelTypeSetupInfo();
        for (CdProperty serverProperty : this.serverProperties) {
            if (!serverProperty.isForPartitioning() || setup == null || !setup.is("PARTITIONING")) continue;
            this.setupProperty(context, "group.tablePartitioning", serverProperty);
        }
    }

    private void setupProperty(UxQueryContext context, String group, CdProperty serverProperty) {
        this.setupProperty(context, group, serverProperty, null, null);
    }

    private void setupProperty(UxQueryContext context, String group, CdProperty serverProperty, @Nullable Object modelOwner, @Nullable DT model) {
        UxFieldTypeInfo defaults = UxBuilderPluginDataTableModelType.getDefaultFieldType(context, serverProperty, modelOwner, model);
        UxFieldType defaultsT = defaults.type;
        UxFieldKind defaultsK = defaultsT.getKind();
        UxFieldEditorMeta defaultsM = null;
        if (defaultsK == UxFieldKind.JSON) {
            defaultsM = UxFieldEditorMeta.createForPreview();
        } else if (defaultsK == UxFieldKind.SQL) {
            defaultsM = UxFieldEditorMeta.createForPreview();
        }
        UxAction defaultsC = defaults.completion;
        List<UxAction> defaultsEA = defaults.extraActions;
        this.addProperty(context, group, serverProperty, null, defaultsT, defaultsM, defaultsC, defaultsEA, serverProperty.isEditableUi(), serverProperty.isVisibleInUi(), serverProperty.isReadOnlyInUi(), serverProperty.isMandatoryInUI());
    }
}

