/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.modeltypes;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderDataSourceNameSelectorForm;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.model.UxModelType;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.type.UxEnumValue;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBuilderDataSourceNameSelectorFormModelType
extends UxModelType<UxBuilderDataSourceNameSelectorForm> {
    protected UxBuilderDataSourceNameSelectorFormModelType() {
        super("dataSourceNameSelectorForm", UxBuilderDataSourceNameSelectorForm.class);
    }

    @Override
    protected void doSetupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable UxBuilderDataSourceNameSelectorForm model) {
        UxBuilderSchemaService service = context.getPersistentSchemaService();
        UxSchemaId schemaId = context.getSchemaId();
        List eValues = schemaId != null ? service.readSchema(schemaId, -1, (lock, schema) -> {
            List<IOlapBuilderDataSource> dataSources = schema.getDataSources(lock);
            return this.setupDataSources(context, dataSources);
        }) : new ArrayList();
        this.addProperty(context, UxBuilderDataSourceNameSelectorForm.NAME, UxFieldTypes.ACTIONABLE(String.class, eValues), true, false, true);
    }

    private UxEnumValue setupDataSource(UxQueryContext context, IOlapBuilderDataSource dataSource) {
        UxBabylonService babylon = context.getUxBabylonService();
        String value = dataSource.getName();
        String caption = dataSource.getName();
        String description = dataSource.getDescription();
        if (CdStringUtils.isNullOrBlank((String)description)) {
            description = babylon.translate(dataSource.getTypeId(), new Serializable[0]);
        }
        return new UxEnumValue(value, caption, UxBabylonService.processHelpText(description));
    }

    private List<UxEnumValue> setupDataSources(UxQueryContext context, List<IOlapBuilderDataSource> dataSources) {
        ArrayList<UxEnumValue> eValues = new ArrayList<UxEnumValue>();
        for (IOlapBuilderDataSource dataSource : dataSources) {
            eValues.add(this.setupDataSource(context, dataSource));
        }
        eValues.sort((o1, o2) -> o1.getCaption().compareToIgnoreCase(o2.getCaption()));
        return eValues;
    }
}

