/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.export;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.executor.common.OlapBuilderTableHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.export.UxExportTableQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentExReply;
import java.io.Closeable;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class UxExportTableXLSQuery
extends UxExportTableQuery {
    public UxExportTableXLSQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        super(meta, requestId, schemaId, tableName, null);
    }

    public UxExportTableXLSQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName) {
        super(meta, requestId, schemaId, null, viewName);
    }

    @Override
    @NotNull
    UxAttachmentExReply createAttachement(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef data) {
        return new UxAttachmentExReply(data.getName() + ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", out -> this.exportTable(queryContext, out, lock, schema, data));
    }

    @Override
    void doExportTable(UxQueryContext context, OutputStream out, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef table, UxExportTableQuery.SimpleFuture future) {
        if (table instanceof IOlapBuilderDataViewDef) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)table));
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        SXSSFSheet sheet = workbook.createSheet(table.getName());
        sheet.trackAllColumnsForAutoSizing();
        MutableBoolean isFirst = new MutableBoolean(true);
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            List columns = table.getSelectedColumns();
            AtomicInteger rowCount = new AtomicInteger(0);
            int EXCEL_MAX_ROWS = 0x100000;
            OlapBuilderTableHelper.readTabularData((OlapEngineRequestContext)context.getOlapEngineRequestContext(), (String)context.getBuilderSnapshot(), (OlapBuilderConnectionPool)connectionPool, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderTabularDataDef)table, row -> {
                if (future.isCancelled()) {
                    throw new RuntimeException("The XLSX export of the table [" + table.getName() + "] has been cancelled");
                }
                if (rowCount.get() >= 0x100000) {
                    return false;
                }
                if (isFirst.booleanValue()) {
                    this.writeExcelHeader((Sheet)sheet, columns);
                    rowCount.incrementAndGet();
                    isFirst.setValue(false);
                }
                this.writeExcelRow((Sheet)sheet, columns, (IOlapBuilderTableRow)row);
                rowCount.incrementAndGet();
                return true;
            }, (int)1048575);
            if (rowCount.get() >= 0x100000) {
                Comment comment = UxExportTableXLSQuery.createComment(workbook, sheet, "WARNING: Limited version of the table. Capped at 1048575 rows");
                sheet.getRow(0).getCell(0).setCellComment(comment);
                workbook.setSheetName(workbook.getSheetIndex(sheet.getSheetName()), sheet.getSheetName() + " - CAPPED");
            }
            sheet.createFreezePane(0, 1);
            sheet.setAutoFilter(new CellRangeAddress(0, 0, 0, columns.size() - 1));
            for (int i = 0; i < columns.size(); ++i) {
                sheet.autoSizeColumn(i);
            }
            workbook.write(out);
            IOUtils.closeQuietly((Closeable)workbook);
        }
    }

    private static Comment createComment(SXSSFWorkbook workbook, SXSSFSheet sheet, String message) {
        CreationHelper factory = workbook.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(0);
        anchor.setRow1(0);
        anchor.setCol2(3);
        anchor.setRow2(5);
        SXSSFDrawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(message));
        comment.setAuthor("System");
        return comment;
    }

    private void writeExcelHeader(Sheet sheet, List<IOlapBuilderDataColumnDef> columns) {
        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < columns.size(); ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(columns.get(i).getName());
            CellStyle style = sheet.getWorkbook().createCellStyle();
            Font font = sheet.getWorkbook().createFont();
            font.setBold(true);
            style.setFont(font);
            cell.setCellStyle(style);
        }
    }

    private void writeExcelRow(Sheet sheet, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow row) {
        int rowNum = sheet.getLastRowNum() + 1;
        Row excelRow = sheet.createRow(rowNum);
        for (int i = 0; i < columns.size(); ++i) {
            Cell cell = excelRow.createCell(i);
            IOlapBuilderDataColumnDef column = columns.get(i);
            this.setCellValue(cell, row.getJavaNativeDataValue(column));
        }
    }

    private void setCellValue(Cell cell, Comparable value) {
        Comparable comparable = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Number.class, LocalDate.class, LocalDateTime.class, Boolean.class}, (Comparable)comparable, n)) {
            case -1: {
                cell.setCellValue((String)null);
                break;
            }
            case 0: {
                String string = (String)((Object)comparable);
                cell.setCellValue(string);
                break;
            }
            case 1: {
                Number number = (Number)((Object)comparable);
                cell.setCellValue(number.doubleValue());
                break;
            }
            case 2: {
                LocalDate jodaDate = (LocalDate)comparable;
                cell.setCellValue(CdTimeUtils.toJavaLocalDate((LocalDate)jodaDate));
                break;
            }
            case 3: {
                LocalDateTime jodaDateTime = (LocalDateTime)comparable;
                cell.setCellValue(CdTimeUtils.toJavaLocalDateTime((LocalDateTime)jodaDateTime));
                break;
            }
            case 4: {
                Boolean bool = (Boolean)comparable;
                cell.setCellValue(bool.booleanValue());
                break;
            }
            default: {
                cell.setCellValue(value.toString());
            }
        }
    }
}

