/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.export;

import com.opencsv.CSVWriter;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.executor.common.OlapBuilderTableHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.export.UxExportTableQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentExReply;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class UxExportTableCSVQuery
extends UxExportTableQuery {
    public UxExportTableCSVQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        super(meta, requestId, schemaId, tableName, null);
    }

    public UxExportTableCSVQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String viewName) {
        super(meta, requestId, schemaId, null, viewName);
    }

    @Override
    UxAttachmentExReply createAttachement(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef data) {
        return new UxAttachmentExReply(data.getName() + ".csv", "text/csv", out -> this.exportTable(queryContext, out, lock, schema, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doExportTable(UxQueryContext context, OutputStream out, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderTabularDataDef table, UxExportTableQuery.SimpleFuture future) {
        if (table instanceof IOlapBuilderDataViewDef) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)table));
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        try {
            ((Writer)writer).write(65279);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CSVWriter csv = new CSVWriter((Writer)writer);
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        MutableBoolean isFirst = new MutableBoolean(true);
        try {
            OlapBuilderTableHelper.readTabularData((OlapEngineRequestContext)context.getOlapEngineRequestContext(), (String)context.getBuilderSnapshot(), (OlapBuilderConnectionPool)connectionPool, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderTabularDataDef)table, row -> {
                if (future.isCancelled()) {
                    throw new RuntimeException("The CSV export of the table [" + table.getName() + "] has been cancelled");
                }
                List columns = table.getSelectedColumns();
                if (isFirst.booleanValue()) {
                    UxExportTableCSVQuery.writeHeader(csv, columns);
                    isFirst.setValue(false);
                }
                UxExportTableCSVQuery.writeRow(csv, columns, row);
                return true;
            });
        }
        finally {
            csv.flushQuietly();
            connectionPool.close();
        }
    }

    private static void writeHeader(CSVWriter csv, List<IOlapBuilderDataColumnDef> columns) {
        int count = columns.size();
        String[] fields = new String[count];
        for (int cc = 0; cc < count; ++cc) {
            IOlapBuilderDataColumnDef column = columns.get(cc);
            fields[cc] = column.getName();
        }
        csv.writeNext(fields);
    }

    private static void writeRow(CSVWriter csv, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow row) {
        int count = columns.size();
        String[] fields = new String[count];
        for (int cc = 0; cc < count; ++cc) {
            IOlapBuilderDataColumnDef column = columns.get(cc);
            Comparable nativeValue = row.getJavaNativeDataValue(column);
            fields[cc] = nativeValue != null ? nativeValue.toString() : "";
        }
        csv.writeNext(fields);
    }
}

