/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.create;

import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateDataTableWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateTypedDataTableWizard;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSaveDataTableWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;

    public UxSaveDataTableWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        int revNumber = -1;
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            Object operation;
            this.setModelTypesSetupInfoForDataTable(queryContext, lock, schema, true);
            UxBuilderCreateDataTableWizard wizard = UxWizardDef.setupCreateDataTableWizardFromJson(queryContext, this.props, -1, this.stepDefs, this.stepModels);
            IOlapBuilderDataSource dataSource = this.setupCreateDataTableWizardDataSourceFromUI(queryContext, lock, schema, wizard);
            OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
            UxBuilderCreateTypedDataTableWizard typedWizard = dataSource.setupCreateDataTableWizard();
            typedWizard.setSteps(wizard.getTypedWizardSteps());
            List discoveredTableNames = typedWizard.getDiscoveredTableNamesFromUI();
            OlapBuilderBaseDataTable createdTable = typedWizard.getCreatedTableFromUI();
            if (discoveredTableNames != null) {
                this.saveDiscoveredTables(queryContext, errorManager, (OlapBuilderBaseDataSource)dataSource, discoveredTableNames);
                operation = "add table(s): " + Arrays.toString(discoveredTableNames.toArray(new String[discoveredTableNames.size()]));
            } else if (createdTable != null) {
                UxSaveDataTableWizardQuery.discoverAndSelectAllColumns(queryContext.asRuntimeContext(), dataSource, createdTable);
                schema.insertDataTable(lock, dataSource.getName(), (IOlapBuilderDataTableDef)createdTable);
                operation = "add table: " + createdTable.getName();
            } else {
                errorManager.addError((CdErrorCode)OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"missing wizard table(s)"});
                operation = "n/a";
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, (String)operation);
            UxActionContinuation continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, queryContext.getUseCase(UxBuilderUseCaseName.DataTables, this.schemaId));
            return UxReply.actionSuccess(continuation);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDiscoveredTables(UxQueryContext context, OlapBuilderErrorManager errorManager, OlapBuilderBaseDataSource dataSource, List<String> discoveredTableNames) {
        List dsTables = dataSource.getTables();
        CdCaseInsensitiveHashMap dsDiscoveredTables = new CdCaseInsensitiveHashMap();
        CdCaseInsensitiveHashMap dsCreatedTables = new CdCaseInsensitiveHashMap();
        for (IOlapBuilderDataTableDef dsTable : dsTables) {
            if (dsTable.isDiscoveredInDataSource()) {
                dsDiscoveredTables.put(dsTable.getName(), dsTable);
                continue;
            }
            dsCreatedTables.put(dsTable.getName(), dsTable);
        }
        for (String discoveredTableName : discoveredTableNames) {
            if (dsCreatedTables.get(discoveredTableName) == null) continue;
            errorManager.addError((CdErrorCode)OlapBuilderErrorCode.DATATABLE_NAME_DUPLICATED, new Serializable[]{discoveredTableName});
        }
        ArrayList<IOlapBuilderDataTableDef> newDiscoveredTables = new ArrayList<IOlapBuilderDataTableDef>();
        if (!discoveredTableNames.isEmpty()) {
            OlapRuntimeContext rContext = context.asRuntimeContext();
            try (IOlapBuilderConnection connection = dataSource.createConnection(rContext, false);){
                connection.open(rContext);
                for (String discoveredTableName : discoveredTableNames) {
                    IOlapBuilderDataTableDef dsDiscoveredTable = (IOlapBuilderDataTableDef)dsDiscoveredTables.get(discoveredTableName);
                    if (dsDiscoveredTable == null) {
                        dsDiscoveredTable = dataSource.createEmptyDiscoverTable(discoveredTableName);
                        dsDiscoveredTable.setDataSource((IOlapBuilderDataSource)dataSource);
                        UxSaveDataTableWizardQuery.discoverAndSelectAllColumns(rContext, errorManager, connection, (IOlapBuilderDataSource)dataSource, (OlapBuilderBaseDataTable)dsDiscoveredTable);
                    }
                    newDiscoveredTables.add(dsDiscoveredTable);
                }
            }
        }
        ArrayList<Object> newTables = new ArrayList<Object>();
        newTables.addAll(newDiscoveredTables);
        newTables.addAll(dsCreatedTables.values());
        dataSource.setTables(newTables);
    }
}

