/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.browse;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTableBrowseQuery;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePage;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableBrowseReply;

public class UxTablePageQuery
extends UxSchemaBuilderQuery {
    private final String tableUUID;
    private final boolean convertValues;
    private final int pageSize;
    private final int pageNumber;

    public UxTablePageQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String tableUUID, boolean convertValues, int pageSize, int pageNumber) {
        super(meta, requestId, schemaId);
        this.tableUUID = tableUUID;
        this.convertValues = convertValues;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (CdStringUtils.isNullOrBlank((String)this.tableUUID)) {
            return UxReply.actionSuccess(new UxTableBrowseReply(null, new UxTablePage()));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataTableDef data = null;
            UxBuilderTableReference table = schema.getDataTableByUUID(lock, this.tableUUID);
            if (table != null) {
                table.table.setDataSource(table.dataSource);
                data = table.table;
            }
            if (data == null) {
                data = schema.getDataViewByUUID(lock, this.tableUUID);
            }
            UxTablePage page = data != null ? UxTableBrowseQuery.browseTablePage(queryContext, lock, schema, (IOlapBuilderTabularDataDef)data, this.convertValues, this.pageSize, this.pageNumber) : new UxTablePage();
            return UxReply.actionSuccess(page);
        });
    }
}

