/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable.analyse;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder2.cruncher.UxCruncherConfiguration;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.analyse.UxTableAnalyseQuery;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxTableAnalyseQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxTableAnalyseQueryMeta TableAnalyse = new UxTableAnalyseQueryMeta();

    protected UxTableAnalyseQueryMeta() {
        super(UxConsoleConstants.QueryName.TableAnalyse);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        String dataSourceName = params.getStringParameter("dataSourceName");
        String tableName = params.getStringParameter("tableName");
        UxBuilderTablePathName tableUniqueName = CdStringUtils.isNotNullAndNotBlank((String)dataSourceName) && CdStringUtils.isNotNullAndNotBlank((String)tableName) ? UxBuilderTablePathName.create(dataSourceName, tableName) : null;
        String viewName = params.getStringParameter("viewName");
        if (tableUniqueName == null && CdStringUtils.isNullOrBlank((String)viewName)) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{"dataSourceName|tableName|viewName"});
        }
        int maxRowCount = params.getIntegerParameter("analyseRowCount", 100000);
        boolean withDistincts = params.getBooleanParameter("analyseDistincts");
        boolean withRelations = params.getBooleanParameter("analyseRelations");
        if (tableUniqueName != null) {
            return new UxTableAnalyseQuery((UxQueryMeta)this, params.getRequestId(), schemaId, tableUniqueName, new UxCruncherConfiguration(maxRowCount, withDistincts, withRelations));
        }
        return new UxTableAnalyseQuery((UxQueryMeta)this, params.getRequestId(), schemaId, viewName, new UxCruncherConfiguration(maxRowCount, withDistincts, withRelations));
    }

    @Nullable
    public static UxAction createActionForTable(UxQueryContext context, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, TableAnalyse, schemaId).withParams(new UxField(babylon, "dataSourceName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(tableName.getDataSourceName())), new UxField(babylon, "tableName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(tableName.getTableName())), new UxField(babylon, "analyseRowCount", new UxFieldMeta(UxFieldTypes.INTEGER), new UxFieldValue(100000)), new UxField(babylon, "analyseDistincts", new UxFieldMeta(UxFieldTypes.BOOLEAN), new UxFieldValue(true)), new UxField(babylon, "analyseRelations", new UxFieldMeta(UxFieldTypes.BOOLEAN), new UxFieldValue(false))).withContinuation(UxActionContinuationKind.DOCKABLE_RESULT).withPlacement(2).build();
    }

    @Nullable
    public static UxAction createActionForView(UxQueryContext context, UxSchemaId schemaId, String viewName) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, TableAnalyse, schemaId).withParams(new UxField(babylon, "viewName", new UxFieldMeta(UxFieldTypes.STRING, false, false, true), new UxFieldValue(viewName)), new UxField(babylon, "analyseRowCount", new UxFieldMeta(UxFieldTypes.INTEGER), new UxFieldValue(100000)), new UxField(babylon, "analyseDistincts", new UxFieldMeta(UxFieldTypes.BOOLEAN), new UxFieldValue(true)), new UxField(babylon, "analyseRelations", new UxFieldMeta(UxFieldTypes.BOOLEAN), new UxFieldValue(false))).withContinuation(UxActionContinuationKind.DOCKABLE_RESULT).withPlacement(2).build();
    }
}

