/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourcesRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxRefreshTableHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveDataTableQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderTablePathName tableName;
    private final UxModel model;

    public UxSaveDataTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName, UxModel model) {
        super(meta, requestId, schemaId);
        this.tableName = tableName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            UxDataSourcesRefresh status;
            IOlapBuilderDataTableDef table;
            IOlapBuilderDataSource dataSource = schema.getExistingDataSource(lock, this.tableName.getDataSourceName());
            IOlapBuilderDataTableDef existingTable = dataSource.getTableByName(this.tableName.getTableName());
            if (existingTable == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"table", this.tableName.getTableName()}));
            }
            this.setModelTypesSetupInfoForDataTable(queryContext, lock, schema, true);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            try {
                table = (IOlapBuilderDataTableDef)converter.convertToServerModel(queryContext, this.model);
            }
            finally {
                queryContext.clearPropertyAccessorListener();
            }
            if (existingTable.getClass() == table.getClass() && existingTable.isRefreshColumnOnUpdate(table) && (status = UxRefreshTableHelper.refresh(queryContext, lock, schema, dataSource, table)) != null && status.hasError()) {
                return UxReply.actionSuccess((UxActionResult)status, new UxActionContinuation(UxActionContinuationKind.RESULT));
            }
            if (!this.tableName.getTableName().equals(table.getName())) {
                UxBuilderTableReference existingTableR = schema.renameDataTable(lock, this.tableName, table.getName());
                converter.update(existingTableR.table, table);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataTableQueryMeta.createUseCase(queryContext, this.schemaId, schema.getName(), null, UxBuilderTablePathName.create(this.tableName.getDataSourceName(), table.getName())));
                operation = "rename/edit table: " + this.tableName.asString() + " into: " + table.getName();
            } else {
                converter.update(existingTable, table);
                continuation = null;
                operation = "edit table: " + table.getName();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

