/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourcesRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxRefreshTableHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxRefreshDataTableQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final String info;
    private final UxBuilderTablePathName tableName;

    public UxRefreshDataTableQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String info, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        super(meta, requestId, schemaId);
        this.info = info;
        this.tableName = tableName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderTableReference table = schema.getDataTable(lock, this.tableName);
            if (table == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"table", this.tableName.asErrorInfo()}));
            }
            UxDataSourcesRefresh status = UxRefreshTableHelper.refresh(queryContext, lock, schema, table.dataSource, table.table);
            if (status != null && status.isUpdated()) {
                service.saveSchemaDef(queryContext.getUserName(), lock, schema, "refresh table columns: " + this.tableName.asString());
                if (!"table".equals(this.info)) {
                    status.withContinuation(UxActionContinuationKind.REFRESH);
                }
                return UxReply.actionSuccess((UxActionResult)status, new UxActionContinuation(UxActionContinuationKind.RESULT));
            }
            return UxReply.actionSuccess();
        });
    }
}

