/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQuery;
import crazydev.iccube.ux.builder.queries.datatable.UxDeleteDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.UxDuplicateTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.UxRefreshDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.analyse.UxTableAnalyseQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTableBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.export.UxExportTableCSVQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.export.UxExportTableXLSQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.process.UxProcessTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.switch_.UxSwitchTableQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataTableQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxDataTableQueryMeta DataTable = new UxDataTableQueryMeta();

    protected UxDataTableQueryMeta() {
        super(UxConsoleConstants.QueryName.DataTable);
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderTablePathName tableName = params.getExistingTableNameParameter("tableName");
        return new UxDataTableQuery(this, params.getRequestId(), schemaId, tableName);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        return this.createQueryUrl(schemaId).addParam("tableName", tableName.asUrlParam());
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, @Nullable String schemaName, @Nullable String uuid, UxBuilderTablePathName tableName) {
        List<UxAction> actions = DataTable.createActions(context, schemaId);
        schemaName = schemaName != null ? schemaName : schemaId.schemaName;
        actions.add(UxTableBrowseQueryMeta.createActionForTable(context, schemaId, tableName));
        actions.add(UxTableAnalyseQueryMeta.createActionForTable(context, schemaId, tableName));
        actions.add(UxRefreshDataTableQueryMeta.createAction(context, schemaId, tableName));
        if (schemaName != null && uuid != null) {
            actions.add(UxSwitchTableQueryMeta.createAction(context, schemaId, schemaName, uuid));
        }
        actions.add(UxExportTableXLSQueryMeta.createActionForTable(context, schemaId, tableName));
        actions.add(UxExportTableCSVQueryMeta.createActionForTable(context, schemaId, tableName));
        actions.add(UxProcessTableQueryMeta.createActionForTable(context, schemaId, tableName));
        actions.add(UxDuplicateTableQueryMeta.createActionForTable(context, schemaId, tableName));
        actions.add(UxDeleteDataTableQueryMeta.createAction(context, schemaId, tableName));
        UxUrl url = DataTable.createQueryUrl(schemaId, tableName);
        return new UxUseCaseBuilder(context, DataTable, schemaId).withId(UxBuilderUseCaseName.DataTable, tableName.asUrlParam()).withUUID(uuid).withUrl(url).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxBuilderUseCaseName.DataTables, schemaId), tableName.asUrlParam(), tableName.getTableName(), UxAdminUseCaseRepository.asBookmark(url))).withActions(actions).build(true);
    }
}

