/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datatable;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByKind;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaUsageHelper;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTablesQuery;
import crazydev.iccube.ux.builder.queries.datatable.UxSaveDataTableQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataTableQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderTablePathName tableName;
    @Nullable
    private String schemaName;
    @Nullable
    private String uuid;

    public UxDataTableQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderTablePathName tableName) {
        super(meta, requestId, schemaId);
        this.tableName = tableName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.schemaName = schema.getName();
            UxBuilderTableReference table = schema.getDataTable(lock, this.tableName);
            if (table == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"table", this.tableName.asErrorInfo()}));
            }
            this.uuid = table.getTableId();
            this.setModelTypesSetupInfoForDataTable(queryContext, lock, schema, true);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, schema, table.table, true);
            List<IOlapBuilderUsedByDef> usages = UxBuilderSchemaUsageHelper.getUsageAllTables(lock, schema, List.of(table)).getUsedBy(table);
            UxDataTableQuery.attachUsedByInformation(queryContext, this.schemaId, model, usages);
            UxAction save = UxSaveDataTableQueryMeta.createAction(queryContext, this.schemaId, schema.getName(), table.getTableId(), this.tableName);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    public static void attachUsedByInformation(UxQueryContext queryContext, UxSchemaId schemaId, UxModel model, List<IOlapBuilderUsedByDef> usages) {
        if (usages != null && !usages.isEmpty()) {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            ArrayList<UxUseCase> usedBy = new ArrayList<UxUseCase>();
            for (IOlapBuilderUsedByDef usage : usages) {
                UxUseCase useCase = UxDataTablesQuery.createUsedByUseCase(queryContext, schemaId, usage);
                if (useCase == null) continue;
                IOlapBuilderUsedByKind type = usage.getUsedByTag();
                useCase.setCaption((String)(type == IOlapBuilderUsedByKind.colors || type == IOlapBuilderUsedByKind.localization ? babylon.translate(type.name(), new Serializable[0]) : babylon.translate(type.name(), new Serializable[0]) + " : " + usage.getName()));
                usedBy.add(useCase);
            }
            if (!usedBy.isEmpty()) {
                model.setUsedBy(babylon.translate("usedByEx", new Serializable[0]), usedBy);
            }
        }
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxDataTableQueryMeta.createUseCase(queryContext, this.schemaId, this.schemaName, this.uuid, this.tableName));
    }
}

