/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.discoverds;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderTableHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRows;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentExReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class UxDiscoverDataSourceQuery
extends UxSchemaBuilderQuery {
    private final String dataSourceName;
    private final boolean filterSystemTables;
    @Nullable
    private final String filterTables;
    private final Integer maxRows;

    public UxDiscoverDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dataSourceName, boolean filterSystemTables, @Nullable String filterTables, @Nullable Integer maxRows) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
        this.filterSystemTables = filterSystemTables;
        this.filterTables = filterTables;
        this.maxRows = maxRows;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource dataSource = schema.getDataSource(lock, this.dataSourceName);
            if (dataSource == null) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_WIZARD_ERROR, (Serializable[])new Serializable[]{"missing data source [" + this.dataSourceName + "]"}));
            }
            XSSFWorkbook wb = new XSSFWorkbook();
            if (dataSource instanceof OlapBuilderBaseDataSource) {
                OlapBuilderBaseDataSource ds = (OlapBuilderBaseDataSource)dataSource;
                if (ds.isDiscoverTablesSupported()) {
                    try (IOlapBuilderConnection conn = null;){
                        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
                        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
                        IOlapBuilderConnection con = conn = connectionPool.getOrCreateOpenedConnection(rContext, dataSource);
                        conn.open(rContext);
                        List tableNames = ds.discoverAllTablesNames(conn, this.filterSystemTables, this.filterTables);
                        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
                        tableNames.forEach(tableName -> {
                            OlapBuilderBaseDataTable table = ds.createEmptyDiscoverTable(tableName);
                            table.resetColumns(table.discoverAllColumns(rContext, con, errorManager));
                            table.setDataSource(dataSource);
                            OlapBuilderBaseDataTableRows info = OlapBuilderTableHelper.browseTabularData((OlapEngineRequestContext)queryContext.getOlapEngineRequestContext(), (String)queryContext.getBuilderSnapshot(), (OlapBuilderConnectionPool)connectionPool, (IOlapBuilderSchemaDef)schema.getDefinition(lock), (IOlapBuilderTabularDataDef)table, (boolean)false, (int)(this.maxRows == null ? 100 : this.maxRows), (int)1);
                            if (!info.getRows().isEmpty()) {
                                XSSFSheet sheet = wb.createSheet(tableName);
                                XSSFRow sheetRow = sheet.createRow(0);
                                for (int c = 0; c < info.getColumns().size(); ++c) {
                                    IOlapBuilderDataColumnDef col = (IOlapBuilderDataColumnDef)info.getColumns().get(c);
                                    sheetRow.createCell(c).setCellValue(col.getName());
                                }
                                for (int r = 0; r < info.getRows().size(); ++r) {
                                    OlapBuilderBaseDataTableRow row = (OlapBuilderBaseDataTableRow)info.getRows().get(r);
                                    sheetRow = sheet.createRow(r + 1);
                                    for (int c = 0; c < row.values().size(); ++c) {
                                        LocalDate date;
                                        XSSFCell cell = sheetRow.createCell(c);
                                        String value = (String)row.values().get(c);
                                        IOlapBuilderDataColumnDef col = (IOlapBuilderDataColumnDef)info.getColumns().get(c);
                                        if (col.getType().isNumber()) {
                                            Number number = (Number)((Object)col.getType().getTypeConverter().toJavaNativeValue(col.getName(), (Object)value));
                                            cell.setCellValue(number.doubleValue());
                                            continue;
                                        }
                                        if (col.getType() == OlapBuilderInputType.DATE) {
                                            date = (LocalDate)col.getType().getTypeConverter().toJavaNativeValue(col.getName(), (Object)value);
                                            cell.setCellValue(java.time.LocalDateTime.ofInstant(date.toDate().toInstant(), ZoneId.systemDefault()));
                                            continue;
                                        }
                                        if (col.getType() == OlapBuilderInputType.DATETIME) {
                                            date = (LocalDateTime)col.getType().getTypeConverter().toJavaNativeValue(col.getName(), (Object)value);
                                            cell.setCellValue(java.time.LocalDateTime.ofInstant(date.toDate().toInstant(), ZoneId.systemDefault()));
                                            continue;
                                        }
                                        cell.setCellValue(value);
                                    }
                                }
                            }
                        });
                    }
                } else {
                    XSSFSheet sheet = wb.createSheet("Sheet");
                    sheet.createRow(0).createCell(0).setCellValue("Discover Tables is not available for this data source");
                }
            }
            return new UxAttachmentExReply(this.dataSourceName + ".xlsx", "application/vnd.ms-excel", out -> {
                wb.write(out);
                wb.close();
            });
        });
    }
}

