/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.create;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.create.UxCreateDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxSaveDataSourceWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;
    private final boolean setupTables;

    public UxSaveDataSourceWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels, boolean setupTables) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
        this.setupTables = setupTables;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        int revNumber = -1;
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderCreateDataSourceWizard wizard = UxWizardDef.setupCreateDataSourceWizardFromJson(queryContext, this.props, -1, this.stepDefs, this.stepModels);
            UxBuilderCreateTypedDataSourceWizard typedWizard = this.setupCreateDataSourceTypedWizardFromUI(queryContext, wizard);
            IOlapBuilderDataSource dataSource = typedWizard.getDataSourceFromUI();
            if (dataSource instanceof OlapBuilderJdbcDataSource) {
                schema.insertDataSource(lock, (IOlapBuilderDataSource)((OlapBuilderJdbcDataSource)dataSource).fromUxEdition());
            } else {
                schema.insertDataSource(lock, dataSource);
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add datasource: " + dataSource.getName());
            UxActionContinuation continuation = this.setupTables ? new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxCreateDataTableQueryMeta.createUseCaseForDataSource(queryContext, this.schemaId, dataSource.getName())) : new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataSourceQueryMeta.createUseCase(queryContext, this.schemaId, dataSource.getName(), null));
            return UxReply.actionSuccess(continuation);
        });
    }
}

