/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource.conn;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSourceException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.action.UxActionStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxTestDataSourceConnectionQuery
extends UxSchemaBuilderQuery {
    private final String dataSourceName;

    public UxTestDataSourceConnectionQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dataSourceName) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource dataSource = schema.getExistingDataSource(lock, this.dataSourceName);
            return this.testConnection(queryContext, dataSource);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UxReply testConnection(UxQueryContext queryContext, IOlapBuilderDataSource dataSource) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxReply reply = this.assertJdbcDriver(queryContext, dataSource);
        if (reply != null) {
            return reply;
        }
        try (IOlapBuilderConnection conn = null;){
            OlapRuntimeContext rContext = queryContext.asRuntimeContext();
            conn = dataSource.createConnection(rContext, true);
            conn.openForCheckConnection(rContext);
            String info = babylon.translate("dataSourceTestConnectionOK", new Serializable[0]);
            UxReply uxReply = UxReply.actionStatus(new UxActionStatus(info, false));
            return uxReply;
        }
    }

    @Nullable
    private UxReply assertJdbcDriver(UxQueryContext queryContext, IOlapBuilderDataSource dataSource) {
        try {
            if (dataSource instanceof OlapBuilderJdbcDataSource) {
                OlapBuilderJdbcDataSource jDataSource = (OlapBuilderJdbcDataSource)dataSource;
                jDataSource.assertJdbcDriver();
            }
            return null;
        }
        catch (OlapBuilderJdbcDataSourceException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] missing datasource [" + dataSource.getName() + "] JDBC driver"), (Throwable)ex);
            UxBabylonService babylon = queryContext.getUxBabylonService();
            String info = babylon.translate(ex.getMessage(), new Serializable[0]);
            return UxReply.actionStatus(new UxActionStatus(info, true));
        }
    }
}

