/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcStatementDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxResultDockType;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTableBrowseQuery;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePage;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxDataSourcesRefresh;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxRefreshTableHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableBrowseReply;

public class UxExecDataSourceQuery
extends UxSchemaBuilderQuery {
    private static final int MAX_ROW_COUNT = 100;
    private final String dataSourceName;

    public UxExecDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dataSourceName) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource dataSource = schema.getExistingDataSource(lock, this.dataSourceName);
            if (!(dataSource instanceof OlapBuilderJdbcDataSource)) {
                return this.asTablePage(new UxTablePage(100, 1, UxTable.empty()));
            }
            OlapBuilderJdbcDataSource jdbc = (OlapBuilderJdbcDataSource)dataSource;
            String sql = jdbc.getPlayground();
            if (CdStringUtils.isNullOrBlank((String)sql)) {
                return this.asTablePage(new UxTablePage(100, 1, UxTable.empty()));
            }
            OlapBuilderJdbcStatementDataTable table = new OlapBuilderJdbcStatementDataTable("playground", sql, jdbc.getDefaultFetchSize());
            UxDataSourcesRefresh refresh = UxRefreshTableHelper.refresh(queryContext, lock, schema, dataSource, (IOlapBuilderDataTableDef)table);
            if (refresh != null && refresh.hasError()) {
                return UxReply.actionSuccess((UxActionResult)refresh, new UxActionContinuation(UxActionContinuationKind.RESULT));
            }
            UxTablePage page = this.execPlayground(queryContext, lock, schema, table);
            return this.asTablePage(page);
        });
    }

    protected UxReply asTablePage(UxTablePage page) {
        UxResultDockName dockName = new UxResultDockName(UxResultDockType.TABLE_BROWSE, this.dataSourceName, this.dataSourceName);
        return UxReply.actionSuccess((UxActionResult)new UxTableBrowseReply(null, page), dockName);
    }

    protected UxTablePage execPlayground(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, OlapBuilderJdbcStatementDataTable table) {
        return UxTableBrowseQuery.browseTablePage(context, lock, schema, (IOlapBuilderTabularDataDef)table, false, 100, 1);
    }
}

