/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePage;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableBrowseReply;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDuplicateDataSourceQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final String info;
    private final String dataSourceName;

    public UxDuplicateDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String info, UxSchemaId schemaId, String dataSourceName) {
        super(meta, requestId, schemaId);
        this.info = info;
        this.dataSourceName = dataSourceName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (CdStringUtils.isNullOrBlank((String)this.dataSourceName)) {
            return UxReply.actionSuccess(new UxTableBrowseReply(null, new UxTablePage()));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            try {
                @Nullable IOlapBuilderDataSource ds = schema.getDataSource(lock, this.dataSourceName);
                String newName = this.dataSourceName;
                while (schema.getDataSource(lock, newName = IOlapBuilderNamedDef.copyName((String)newName)) != null) {
                }
                IOlapBuilderDataSource duplicatedDS = UxBuilderSchemaService.duplicateDefinition(queryContext.getOlapEngineComponent().getBuilderMetaInformationRepository(), ds);
                duplicatedDS.setName(newName);
                duplicatedDS.removeAllTable();
                schema.insertDataSource(lock, duplicatedDS);
                service.saveSchemaDef(queryContext.getUserName(), lock, schema, "duplicate data source: " + this.dataSourceName);
                UxActionContinuation continuation = null;
                if (!"table".equals(this.info)) {
                    continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDataSourceQueryMeta.createUseCase(queryContext, this.schemaId, newName, null));
                }
                return UxReply.actionSuccess(continuation);
            }
            catch (JAXBException | IOException ex) {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] duplicate view [" + this.dataSourceName + "] error"), ex);
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_DS_DUPLICATE, (Serializable[])new Serializable[]{this.dataSourceName, ex.getMessage()}));
            }
        });
    }
}

