/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxDataSourcesQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxDataSourcesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableHeaders header = UxTableHeaders.create(babylon, "name", "description", "type");
            UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IOlapBuilderDataSource>("name", babylon.translate("filterDataSourceName", new Serializable[0]), IOlapBuilderNamedDef::getName), new UxFilterMeta<IOlapBuilderDataSource>("description", babylon.translate("filterDataSourceDescription", new Serializable[0]), IOlapBuilderDataSource::getDescription));
            UxTableRowSearcher<IOlapBuilderDataSource> searcher = new UxTableRowSearcher<IOlapBuilderDataSource>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean isAccepting(IOlapBuilderDataSource row, String searchText) {
                    return this.isContaining(searchText, row.getName());
                }
            };
            List<IOlapBuilderDataSource> dataSources_ = schema.getSortedDataSources(lock);
            List<IOlapBuilderDataSource> dataSources = this.filter(this.tableOptions, searcher, filterMetas, dataSources_);
            int totalRowCount = dataSources.size();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (IOlapBuilderDataSource dataSource : dataSources) {
                rows.add(UxDataSourcesQuery.createRow(queryContext, this.schemaId, dataSource));
            }
            UxTable table = UxTable.create(options, header, rows);
            UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
            return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
        });
    }

    private static UxTableRow createRow(UxQueryContext context, UxSchemaId schemaId, IOlapBuilderDataSource dataSource) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxDataSourceQueryMeta.createUseCase(context, schemaId, dataSource.getName(), null);
        cells.add(new UxTableCell((Object)dataSource.getName(), useCase));
        cells.add(new UxTableCell(dataSource.getDescription()));
        UxBabylonService babylon = context.getUxBabylonService();
        if (dataSource instanceof OlapBuilderJdbcDataSource) {
            OlapBuilderJdbcDataSource jdbcDataSource = (OlapBuilderJdbcDataSource)dataSource;
            cells.add(new UxTableCell(babylon.translateEnumCaption(OlapBuilderDriverType.class, jdbcDataSource.getDbType().name())));
        } else {
            cells.add(new UxTableCell(babylon.translate(dataSource.getTypeId(), new Serializable[0])));
        }
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.DataSources, this.schemaId));
    }
}

