/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.datasource.UxCreateSchemaDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQuery;
import crazydev.iccube.ux.builder.queries.datasource.UxDeleteDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxDuplicateDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxExecDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxRefreshDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.conn.UxTestDataSourceConnectionQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.discoverds.UxDiscoverDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.switch_.UxSwitchDataSourceQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDataSourceQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxDataSourceQueryMeta DataSource = new UxDataSourceQueryMeta();

    protected UxDataSourceQueryMeta() {
        super(UxConsoleConstants.QueryName.DataSource);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return null;
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        String name = params.getExistingStringParameter("name");
        return new UxDataSourceQuery(this, params.getRequestId(), schemaId, name);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, String name) {
        return this.createQueryUrl(schemaId).addParam("name", name);
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, String name, @Nullable String dataSourceHelpUrl) {
        return UxDataSourceQueryMeta.createUseCase(context, schemaId, name, dataSourceHelpUrl, true);
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, String name, @Nullable String dataSourceHelpUrl, boolean withActions) {
        List<Object> actions;
        if (withActions) {
            actions = DataSource.createActions(context, schemaId);
            ArrayList moreActions = new ArrayList();
            if (name != null) {
                try {
                    UxBuilderSchemaService service = context.getPersistentSchemaService();
                    boolean withQueryConsole = service.readSchema(schemaId, -1, (lock, schema) -> {
                        IOlapBuilderDataSource ds = schema.getDataSource(lock, name);
                        if (ds instanceof OlapBuilderJdbcDataSource) {
                            return true;
                        }
                        if (ds instanceof OlapBuilderSpssDataSource) {
                            moreActions.add(UxCreateSchemaDataSourceQueryMeta.createAction(context, schemaId, name));
                        }
                        return false;
                    });
                    if (withQueryConsole) {
                        actions.add(UxExecDataSourceQueryMeta.createAction(context, schemaId, name));
                    }
                }
                catch (RuntimeException ignored) {
                    OlapLoggers.UX_REQUEST.warn((Object)"[UX] could not determine withQueryConsole", (Throwable)ignored);
                }
                actions.add(UxTestDataSourceConnectionQueryMeta.createAction(context, schemaId, name));
                actions.add(UxRefreshDataSourceQueryMeta.createAction(context, schemaId, name));
                actions.add(UxSwitchDataSourceQueryMeta.createAction(context, schemaId, name));
                actions.add(UxDuplicateDataSourceQueryMeta.createAction(context, schemaId, name));
                actions.add(UxDeleteDataSourceQueryMeta.createAction(context, schemaId, name));
                actions.add(UxDiscoverDataSourceQueryMeta.createAction(context, schemaId, name));
                actions.addAll(moreActions);
            }
        } else {
            actions = Collections.emptyList();
        }
        UxUrl url = DataSource.createQueryUrl(schemaId, name);
        UxUrl helpUrl = CdStringUtils.isNotNullAndNotBlank((String)dataSourceHelpUrl) ? UxUrlConstants.APP_URL_HELP_ROOT.addParam("ic3topic", "server.user_guide.schemas_cubes." + dataSourceHelpUrl) : null;
        return new UxUseCaseBuilder(context, DataSource, schemaId).withId(UxBuilderUseCaseName.DataSource, name).withUrl(url).withHelpUrl(helpUrl != null ? helpUrl.toUrl() : null).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxBuilderUseCaseName.DataSources, schemaId), name, name, UxAdminUseCaseRepository.asBookmark(url))).withActions(actions).build(true);
    }
}

