/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxSaveDataSourceQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxDataSourceQuery
extends UxSchemaBuilderQuery {
    private final String name;
    @Nullable
    private String dataSourceHelpUrl;

    public UxDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource<?> ds = this.getExistingDataSource(lock, schema);
            queryContext.setModelTypeSetupInfo(question -> {
                if (question.equals("NAME_WRITE")) {
                    return true;
                }
                if (question.equals("SHOW_DRIVER_TYPE_RO")) {
                    return ds instanceof OlapBuilderJdbcDataSource;
                }
                return false;
            });
            this.dataSourceHelpUrl = ds.getHelpUrl();
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, schema, ds, true);
            UxAction save = UxSaveDataSourceQueryMeta.createAction(queryContext, this.schemaId, ds.getName());
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    private IOlapBuilderDataSource<?> getExistingDataSource(UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        IOlapBuilderDataSource ds = schema.getExistingDataSource(lock, this.name);
        if (ds instanceof OlapBuilderJdbcDataSource) {
            OlapBuilderJdbcDataSource jdbcDS = (OlapBuilderJdbcDataSource)ds;
            return jdbcDS.toUxEdition();
        }
        return ds;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxDataSourceQueryMeta.createUseCase(queryContext, this.schemaId, this.name, this.dataSourceHelpUrl));
    }
}

