/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.datasource;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssConnection;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssDataSource;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappers;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappersOptions;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssTable;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderStatisticalDimension;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.datatable.refresh.UxRefreshTableHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UxCreateSchemaDataSourceQuery
extends UxSchemaBuilderQuery {
    private final String dataSourceName;

    public UxCreateSchemaDataSourceQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dataSourceName) {
        super(meta, requestId, schemaId);
        this.dataSourceName = dataSourceName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDataSource dataSource = schema.getExistingDataSource(lock, this.dataSourceName);
            if (dataSource instanceof OlapBuilderSpssDataSource) {
                UxCreateSchemaDataSourceQuery.createSchema(queryContext, lock, schema, dataSource, queryContext.asRuntimeContext());
                service.saveSchemaDef(queryContext.getUserName(), lock, schema, "create Schema for " + this.dataSourceName);
            }
            return UxReply.actionSuccess();
        });
    }

    public static void createSchema(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataSource<?> dataSource, OlapRuntimeContext runtimeContext) {
        List<OlapBuilderSpssMappers> withStats;
        OlapBuilderSpssDataSource ds = (OlapBuilderSpssDataSource)dataSource;
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        OlapBuilderSpssConnection con = (OlapBuilderSpssConnection)connectionPool.getOrCreateOpenedConnection(runtimeContext, (IOlapBuilderDataSource)ds);
        List refTables = con.getRefTables();
        OlapBuilderSpssMappersOptions options = ((OlapBuilderSpssDataSource)con.getDataSource()).getMapperOptions();
        HashMap map = new HashMap();
        String cubeName = "Cube";
        if (options.clearSchemaOnNew) {
            IOlapBuilderCubeDef existingCube = schema.getCubeByName(lock, "Cube");
            if (existingCube != null) {
                schema.deleteCube(lock, UxBuilderCubeUniqueName.create(existingCube));
            }
            schema.deleteAllDimensions(lock);
            schema.deleteAllTables(lock, ds.getName());
        }
        refTables.forEach(ref -> {
            IOlapBuilderDataTableDef table = UxCreateSchemaDataSourceQuery.createAndAddTable(queryContext, lock, schema, dataSource, ds, ref);
            map.put(ref, table);
        });
        ArrayList dimensions = new ArrayList();
        refTables.forEach(ref -> {
            OlapBuilderMultiLevelDimension dimension = UxCreateSchemaDataSourceQuery.createDimension(options, ref, (IOlapBuilderDataTableDef)map.get(ref));
            IOlapBuilderDimensionDef existing = schema.getDimensionByName(lock, dimension.getName());
            if (existing != null) {
                schema.deleteDimension(lock, UxBuilderDimensionUniqueName.create(existing));
            }
            dimensions.add(dimension);
            schema.insertDimension(lock, (IOlapBuilderDimensionDef)dimension);
        });
        StringBuilder script = new StringBuilder();
        if (options.createStats && !(withStats = refTables.stream().filter(OlapBuilderSpssMappers::hasAssociatedStats).collect(Collectors.toList())).isEmpty()) {
            String[] stats = (String[])withStats.stream().map(OlapBuilderSpssMappers::getDimensionName).toArray(String[]::new);
            OlapBuilderStatisticalDimension statDimension = new OlapBuilderStatisticalDimension("Stats", "default", stats);
            schema.insertDimension(lock, (IOlapBuilderDimensionDef)statDimension);
            withStats.forEach(mapper -> {
                String dimName = options.useVariableAsDimensionName ? mapper.getVariableName() : mapper.getDimensionName();
                mapper.addToMdxScript(script, mapper.getDimensionName(), dimName);
            });
        }
        if (script.length() != 0) {
            script.insert(0, "-- \n-- Drop all calc. members, sets and functions declared at schema/cube levels. \n-- \n\nDROP *\n\n-- \n-- Functions \n-- \n\nCREATE FUNCTION StatsCalcFun(_statsMember, _hier) AS \n    eval( \n       FILTER( DESCENDANTS( _hier.contextMember,,LEAVES) as t, t.currentMember.name = _statsMember.name )\n       ,\n       (_statsMember.hierarchy.defaultMember)\n    )\n-- \n-- Sets. \n-- \n\n-- \n-- Calculated Measures/Members. \n--\n");
            schema.setScript(lock, new OlapBuilderScript(script.toString()), true);
        }
        OlapBuilderSpssMappers factRef = con.getRefData();
        IOlapBuilderDataTableDef factTable = UxCreateSchemaDataSourceQuery.createAndAddTable(queryContext, lock, schema, dataSource, ds, factRef);
        IOlapBuilderCubeDef existingCube = schema.getCubeByName(lock, "Cube");
        if (existingCube != null) {
            schema.deleteCube(lock, UxBuilderCubeUniqueName.create(existingCube));
        }
        ArrayList<OlapBuilderMeasure> measures = new ArrayList<OlapBuilderMeasure>();
        measures.add(new OlapBuilderMeasure("Count", OlapAggregationType.COUNT, factTable.lookupSelectedColumn(factRef.getKeyColumnName())));
        List measurMappers = con.getMeasures();
        measurMappers.forEach(mapper -> measures.add(new OlapBuilderMeasure(mapper.getMeasureName(), OlapAggregationType.SUM, factTable.lookupSelectedColumn(mapper.getTableName()))));
        OlapBuilderFacts factDef = new OlapBuilderFacts("Default", (IOlapBuilderTabularDataDef)factTable, measures);
        OlapBuilderCube cube = new OlapBuilderCube("Cube", (IOlapBuilderBaseFactsDef)factDef);
        schema.insertCube(lock, (IOlapBuilderCubeDef)cube);
        for (int i = 0; i < dimensions.size(); ++i) {
            OlapBuilderMultiLevelDimension dim = (OlapBuilderMultiLevelDimension)dimensions.get(i);
            OlapBuilderSpssMappers refMap = (OlapBuilderSpssMappers)refTables.get(i);
            IOlapBuilderDataTableDef dimTable = (IOlapBuilderDataTableDef)map.get(refMap);
            IOlapBuilderDataColumnDef dimCol = dimTable.lookupSelectedColumn(refMap.getKeyColumnName());
            IOlapBuilderDataColumnDef factCol = factTable.lookupSelectedColumn(refMap.getTableName());
            OlapBuilderDataViewLinks link = OlapBuilderDataViewLinks.createLink((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.LAST_LEVEL, (IOlapBuilderDataColumnDef)dimCol, (IOlapBuilderDataColumnDef)factCol);
            factDef.addLink((IOlapBuilderDimensionDef)dim, (IOlapBuilderDataViewLinksDef)link);
        }
    }

    @NotNull
    private static IOlapBuilderDataTableDef createAndAddTable(UxQueryContext queryContext, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDataSource dataSource, OlapBuilderSpssDataSource ds, OlapBuilderSpssMappers ref) {
        String tableName = ref.getTableName();
        IOlapBuilderDataTableDef table = ds.getTableByName(tableName);
        if (table == null) {
            table = new OlapBuilderSpssTable(tableName, ref.getDescription());
            ds.addTable(table);
        } else {
            table.setDescription(ref.getDescription());
        }
        UxRefreshTableHelper.refresh(queryContext, lock, schema, dataSource, table);
        return table;
    }

    private static OlapBuilderMultiLevelDimension createDimension(OlapBuilderSpssMappersOptions options, OlapBuilderSpssMappers ref, IOlapBuilderDataTableDef<?> tableDef) {
        OlapBuilderMultiLevelDimension dim = new OlapBuilderMultiLevelDimension();
        String dimName = options.useVariableAsDimensionName ? ref.getVariableName() : ref.getDimensionName();
        dim.setName(dimName);
        dim.setDataTableId(tableDef.getId());
        OlapBuilderMultiLevelHierarchy hier = new OlapBuilderMultiLevelHierarchy();
        hier.setName(ref.getDimensionName());
        hier.setHasAllLevel(true);
        IOlapBuilderDataColumnDef intermediateLevel = tableDef.lookupSelectedColumn(ref.getIntermediateLevelColumnName());
        if (intermediateLevel != null) {
            hier.addLevelForUX((IOlapBuilderBaseHierarchyLevelDef)new OlapBuilderHierarchyLevel("Question - L", null, intermediateLevel, null, new IOlapBuilderPropertyDef[0]));
        }
        IOlapBuilderDataColumnDef nameCol = tableDef.lookupSelectedColumn(ref.getNameColumnName());
        IOlapBuilderDataColumnDef keyCol = tableDef.lookupSelectedColumn(ref.getKeyColumnName());
        OlapBuilderHierarchyLevel level = new OlapBuilderHierarchyLevel(intermediateLevel == null ? " Options - L" : "Answer - L", null, nameCol, keyCol, new IOlapBuilderPropertyDef[0]);
        hier.addLevelForUX((IOlapBuilderBaseHierarchyLevelDef)level);
        dim.addHierarchyForUX((IOlapBuilderHierarchyDef)hier);
        return dim;
    }
}

