/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.cube;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.queries.cube.UxCubeQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveCubeQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderCubeUniqueName cubeName;
    private final UxModel model;

    public UxSaveCubeQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderCubeUniqueName cubeName, UxModel model) {
        super(meta, requestId, schemaId);
        this.cubeName = cubeName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderCubeDef cube = (IOlapBuilderCubeDef)converter.convertToServerModel(queryContext, this.model);
            if (!cube.getUUID().equals(this.cubeName.asUUID())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_UUID_MISMATCH, (Serializable[])new Serializable[]{this.cubeName.asUUID(), cube.getUUID()}));
            }
            if (!this.cubeName.getCubeName().equals(cube.getName())) {
                IOlapBuilderCubeDef existingCube = schema.renameCube(lock, this.cubeName, cube.getName());
                converter.update(existingCube, cube);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxCubeQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderCubeUniqueName.create(existingCube)));
                operation = "rename/edit cube: " + this.cubeName.asString() + " into: " + cube.getName();
            } else {
                IOlapBuilderCubeDef existingCube = schema.getExistingCube(lock, this.cubeName);
                converter.update(existingCube, cube);
                continuation = null;
                operation = "edit cube: " + this.cubeName.asString();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

