/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.cube;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.model.UxExtraNavigationKeyId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNodeId;
import crazydev.iccube.ux.builder.queries.cube.UxCreateCubeQueryMeta;
import crazydev.iccube.ux.builder.queries.cube.UxCubeQuery;
import crazydev.iccube.ux.builder.queries.cube.UxDeleteCubeQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.create.UxCreateMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxCubeQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxCubeQueryMeta Cube = new UxCubeQueryMeta();

    protected UxCubeQueryMeta() {
        super(UxConsoleConstants.QueryName.Cube);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return UxUrlConstants.HELP_SCHEMA_FACTS;
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderCubeUniqueName name = params.getExistingCubeNameParameter("name");
        return new UxCubeQuery(this, params.getRequestId(), schemaId, name);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, UxBuilderCubeUniqueName name) {
        return this.createQueryUrl(schemaId).addParam("name", name.asUrlParam());
    }

    @Nullable
    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, @Nullable UxBuilderCubeUniqueName prevName, UxBuilderCubeUniqueName name) {
        return UxCubeQueryMeta.createUseCase(context, UxActionSetup.ALL, schemaId, prevName, name);
    }

    @Nullable
    public static UxUseCase createUseCase(UxQueryContext context, UxActionSetup actionSetup, UxSchemaId schemaId, @Nullable UxBuilderCubeUniqueName prevName, UxBuilderCubeUniqueName name) {
        List<UxAction> actions = null;
        if (actionSetup == UxActionSetup.ALL) {
            actions = Cube.createActions(context, schemaId);
            actions.add(UxCreateMeasureGroupQueryMeta.createAction(context, schemaId, name.getCubeName(), 8));
            actions.add(UxCreateCubeQueryMeta.createAction(context, schemaId, 2));
            actions.add(UxDeleteCubeQueryMeta.createAction(context, schemaId, name));
        } else if (actionSetup == UxActionSetup.NAVIGATION_TREE) {
            actions = new ArrayList<UxAction>();
            actions.add(UxCreateMeasureGroupQueryMeta.createAction(context, schemaId, name.getCubeName(), 2));
            actions.add(UxCreateCubeQueryMeta.createAction(context, schemaId, 2));
            actions.add(UxDeleteCubeQueryMeta.createAction(context, schemaId, name));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = Cube.createQueryUrl(schemaId, name);
        UxUseCaseBuilder builder = new UxUseCaseBuilder(context, Cube, schemaId).withId(UxBuilderUseCaseName.Cube, name.getCubeName()).withExtraNavigationKeyId(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(name))).withCaption(babylon.translate("cubeUC", new Serializable[]{name.getCubeName()})).withParentId(UxBuilderUseCaseName.Measures).withUrl(url).withActions(actions);
        if (prevName != null) {
            builder = builder.withExtraNavigationKeyId_(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(prevName)));
        }
        return builder.build(actionSetup != UxActionSetup.NONE);
    }
}

