/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.cube;

import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.queries.cube.UxCubeQueryMeta;
import crazydev.iccube.ux.builder.queries.cube.UxSaveCubeQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxCubeQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderCubeUniqueName name;
    @Nullable
    private IOlapBuilderCubeDef cube;

    public UxCubeQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderCubeUniqueName name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.cube = schema.getExistingCube(lock, this.name);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, schema, this.cube, true);
            UxAction save = UxSaveCubeQueryMeta.createAction(queryContext, this.schemaId, this.name);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.cube != null) {
            reply.withUseCase(UxCubeQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderCubeUniqueName.create(this.cube)));
        }
    }
}

