/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.model;

import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaConstraintHelper;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.model.UxBuilderTabularDataUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UxBuilderSchemaUsageHelper {
    private UxBuilderSchemaUsageHelper() {
    }

    public static UxBuilderTabularDataUsage getUsageAllTables(UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable List<UxBuilderTableReference> filter) {
        try {
            Set<String> acceptedTables = UxBuilderSchemaUsageHelper.getAcceptedTables(filter);
            Map<String, List<IOlapBuilderUsedByDef>> allUsedBy = UxBuilderSchemaUsageHelper.getAllUsedBy(lock, schema, acceptedTables, false);
            Set<String> allNotUsed = UxBuilderSchemaUsageHelper.getAllNotUsed(lock, schema, acceptedTables, allUsedBy, false);
            return new UxBuilderTabularDataUsage(allUsedBy, allNotUsed);
        }
        catch (RuntimeException ignored) {
            OlapLoggers.BUILDER.warn((Object)"[table] could not extract Used By information", (Throwable)ignored);
            return new UxBuilderTabularDataUsage();
        }
    }

    public static UxBuilderTabularDataUsage getUsageAllViews(UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable List<IOlapBuilderDataViewDef<?>> filter) {
        try {
            Set<String> acceptedTabularData = UxBuilderSchemaUsageHelper.getAcceptedViews(filter);
            Map<String, List<IOlapBuilderUsedByDef>> allUsedBy = UxBuilderSchemaUsageHelper.getAllUsedBy(lock, schema, acceptedTabularData, true);
            Set<String> allNotUsed = UxBuilderSchemaUsageHelper.getAllNotUsed(lock, schema, acceptedTabularData, allUsedBy, true);
            return new UxBuilderTabularDataUsage(allUsedBy, allNotUsed);
        }
        catch (RuntimeException ignored) {
            OlapLoggers.BUILDER.warn((Object)"[table] could not extract Used By information", (Throwable)ignored);
            return new UxBuilderTabularDataUsage();
        }
    }

    @NotNull
    private static Set<String> getAllNotUsed(UxBuilderSchemaLock lock, UxBuilderSchema schema, Set<String> acceptedTabularData, Map<String, List<IOlapBuilderUsedByDef>> allUsedBy, boolean view) {
        HashSet<String> allNotUsed = new HashSet<String>();
        if (!view) {
            schema.forEachTable(lock, table -> {
                String uuid = table.getTableId();
                if ((acceptedTabularData == null || acceptedTabularData.contains(uuid)) && allUsedBy.get(uuid) == null) {
                    allNotUsed.add(uuid);
                }
            });
        } else {
            schema.forEachView(lock, table -> {
                String uuid = table.getId();
                if ((acceptedTabularData == null || acceptedTabularData.contains(uuid)) && allUsedBy.get(uuid) == null) {
                    allNotUsed.add(uuid);
                }
            });
        }
        return allNotUsed;
    }

    @NotNull
    private static Map<String, List<IOlapBuilderUsedByDef>> getAllUsedBy(UxBuilderSchemaLock lock, UxBuilderSchema schema, Set<String> acceptedTabularData, boolean view) {
        HashMap<String, List<IOlapBuilderUsedByDef>> allUsedBy = new HashMap<String, List<IOlapBuilderUsedByDef>>();
        UxBuilderSchemaConstraintHelper.onTabularDataUsage(lock, schema, (uuid, usedBy) -> {
            IOlapBuilderTabularDataDef tabularData;
            if (uuid != null && (acceptedTabularData == null || acceptedTabularData.contains(uuid)) && (tabularData = schema.getTabularData(lock, uuid)) != null && (!view && !tabularData.isView() || view && tabularData.isView())) {
                List usages = allUsedBy.computeIfAbsent(uuid, k -> new ArrayList());
                usages.add(usedBy);
            }
        });
        return allUsedBy;
    }

    @Nullable
    private static Set<String> getAcceptedTables(@Nullable List<UxBuilderTableReference> filter) {
        HashSet<String> acceptedTables;
        HashSet<String> hashSet = acceptedTables = filter != null ? new HashSet<String>() : null;
        if (acceptedTables != null) {
            for (UxBuilderTableReference ref : filter) {
                acceptedTables.add(ref.getTableId());
            }
        }
        return acceptedTables;
    }

    @Nullable
    private static Set<String> getAcceptedViews(@Nullable List<IOlapBuilderDataViewDef<?>> filter) {
        HashSet<String> acceptedTables;
        HashSet<String> hashSet = acceptedTables = filter != null ? new HashSet<String>() : null;
        if (acceptedTables != null) {
            for (IOlapBuilderDataViewDef<?> view : filter) {
                acceptedTables.add(view.getId());
            }
        }
        return acceptedTables;
    }
}

