/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.model;

import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByDef;
import crazydev.iccube.builder.model.def.IOlapBuilderUsedByKind;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBuilderBridge
implements IOlapBuilderUsedByDef {
    private final IOlapBuilderCubeDef cube;
    private final IOlapBuilderBaseFactsDef<?, ?> facts;
    @Nullable
    private final IOlapBuilderDimensionDef<?> dimension;
    private final IOlapBuilderDataViewLinksDef bridge;

    public UxBuilderBridge(IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef<?, ?> facts, @Nullable IOlapBuilderDimensionDef<?> dimension, IOlapBuilderDataViewLinksDef bridge) {
        this.cube = cube;
        this.facts = facts;
        this.dimension = dimension;
        this.bridge = bridge;
        if (!bridge.isBridge()) {
            throw new RuntimeException("internal error : unexpected link");
        }
    }

    public IOlapBuilderUsedByKind getUsedByTag() {
        return IOlapBuilderUsedByKind.bridge;
    }

    public String getName() {
        return this.facts.getName() + (String)(this.dimension != null ? " : " + this.dimension.getName() : "");
    }

    public List<String> getTableIds() {
        OlapBuilderDataViewLinks link;
        OlapBuilderDataViewLinks.OlapBuilderBridges defs;
        IOlapBuilderDataViewLinksDef iOlapBuilderDataViewLinksDef = this.bridge;
        if (iOlapBuilderDataViewLinksDef instanceof OlapBuilderDataViewLinks && (defs = (link = (OlapBuilderDataViewLinks)iOlapBuilderDataViewLinksDef).getBridgeDefs()) != null) {
            ArrayList<String> tableIds = new ArrayList<String>();
            List simpleBridges = defs.getBridges();
            for (OlapBuilderBridgeRef simpleBridge : simpleBridges) {
                String bridgeTableId = simpleBridge.getBridgeTableId();
                if (bridgeTableId == null) continue;
                tableIds.add(bridgeTableId);
            }
            return tableIds;
        }
        return Collections.emptyList();
    }

    public IOlapBuilderCubeDef getCube() {
        return this.cube;
    }

    public IOlapBuilderBaseFactsDef<?, ?> getFacts() {
        return this.facts;
    }
}

