/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.code.queries.provider;

import crazydev.iccube.ux.builder.code.queries.UxCodeCompletion;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionKind;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionProvider;
import crazydev.iccube.ux.builder.code.queries.UxCodeSuggestion;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UxCodeCompletionJava
extends UxCodeCompletionProvider {
    private static final String[] EMPTY_COMPLETION = new String[0];
    private static String[] javaViewEmpty = new String[]{"context", "mainTableRow", "row", "cachedTable"};
    private static String[] javaView = new String[]{"IOlapColumnDef", "IOlapDataTableRow", "LocalDate", "LocalDateTime", "context.fireRow(row)", "context.newRow()", "context.copyRow(row)", "mainTable.getName()", "mainTable.getColumns()", "mainTable.getColumn()", "mainTableRow.getTableDef()", "mainTableRow.get(columnDef)", "mainTableRow.get(columnName)", "mainTableRow.getAsArray(columnDef)", "mainTableRow.getAsInteger(columnName)", "mainTableRow.getAsLong(columnName)", "mainTableRow.getAsDouble(columnName)", "mainTableRow.getAsString(columnName)", "mainTableRow.getAsDate(columnName)", "mainTableRow.getAsDateTime(columnName)", "mainTableRow.getAsInteger(columnDef)", "mainTableRow.getAsLong(columnDef)", "mainTableRow.getAsDouble(columnDef)", "mainTableRow.getAsString(columnDef)", "mainTableRow.getAsDate(columnDef)", "mainTableRow.getAsDateTime(columnDef)", "row.get(columnDef)", "row.get(columnName)", "row.getAsArray(columnDef)", "row.getAsInteger(columnName)", "row.getAsLong(columnName)", "row.getAsDouble(columnName)", "row.getAsString(columnName)", "row.getAsDate(columnName)", "row.getAsDateTime(columnName)", "row.getAsInteger(columnDef)", "row.getAsLong(columnDef)", "row.getAsDouble(columnDef)", "row.getAsString(columnDef)", "row.getAsDate(columnDef)", "row.getAsDateTime(columnDef)", "row.getColumns()", "row.getColumn(columnName)", "row.set(columnName,value)", "row.set(columnName,value)", "row.getTableDef()", "row.toValue(columnDef,value)", "cachedTable.row(rowNumber)", "cachedTable.count()", "cachedTable.min(columnName)", "cachedTable.max(columnName)", "cachedTable.sum(columnName)", "cachedTable.countNotNull(columnName)", "cachedTable.distinct(columnName)", "cachedTable.distinct(columnNames)", "cachedTable.aggregate(columnName, aggregationType)", "cachedTable.columns()", "cachedTable.stream()", "cachedTable.groupBy(groupByColumns,aggregationColumns,aggregationTypes)", "cachedTable.filter(columnName,value)", "cachedTable.filter(columnName,values)", "cachedTable.firstMatching(columnName, value)", "cachedTable.firstMatching(columnName, values)", "cachedTable.get(rowId, columnName)", "cachedTable.set(rowId, columnName, newValue)", "cachedTable.replace(columnName, lookupValue,newValue)", "cachedTable.fillMissingPrev(columnName)", "cachedTable.fillMissingNext(columnName)", "cachedTable.sortAsc(columnName)", "cachedTable.sortDesc(columnName)"};
    private static String[] simpleJavaViewEmpty = new String[]{"row", "columnDef", "cache"};
    private static String[] simpleJavaView = new String[]{"row.getTableDef()", "row.get(columnDef)", "row.get(columnName)", "row.getAsArray(columnDef)", "row.getAsInteger(columnName)", "row.getAsDouble(columnName)", "row.getAsString(columnName)", "row.getAsDate(columnName)", "row.getAsDateTime(columnName)", "row.getAsInteger(columnDef)", "row.getAsDouble(columnDef)", "row.getAsString(columnDef)", "row.getAsDate(columnDef)", "row.getAsDateTime(columnDef)", "row.toValue(columnDef,value)", "columnDef.getIndex()", "columnDef.getName()", "columnDef.getType()", "columnDef.getTableType()", "cache.get(key)", "cache.put(key,value)", "cache.computeIfAbsent(key, key -> newValue)"};
    private static String[] importStatement = new String[]{"import"};
    private static List<Character> wordSeparator = Arrays.asList(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf(';'), Character.valueOf('}'), Character.valueOf('{'));
    private final String[] viewCodeCompl;
    private final String[] emptyCompletion;

    public UxCodeCompletionJava(UxCodeCompletionKind completionKind, int maxCount, String code, int offset) {
        super(completionKind, maxCount, code, offset);
        switch (completionKind) {
            case JAVA_VIEW_CODE: {
                this.viewCodeCompl = javaView;
                this.emptyCompletion = javaViewEmpty;
                break;
            }
            case JAVA_VIEW_CODE_SIMPLE: {
                this.viewCodeCompl = simpleJavaView;
                this.emptyCompletion = simpleJavaViewEmpty;
                break;
            }
            case JAVA_VIEW_IMPORT: {
                this.viewCodeCompl = importStatement;
                this.emptyCompletion = EMPTY_COMPLETION;
                break;
            }
            default: {
                this.viewCodeCompl = EMPTY_COMPLETION;
                this.emptyCompletion = EMPTY_COMPLETION;
            }
        }
    }

    @Override
    public UxCodeCompletion complete(UxQueryContext context) {
        String toScan;
        ArrayList<UxCodeSuggestion> suggestions = new ArrayList<UxCodeSuggestion>();
        if (this.offset < 0 || this.offset > this.code.length() || this.viewCodeCompl.length == 0) {
            return new UxCodeCompletion(suggestions);
        }
        int startPos = 0;
        for (int i = this.offset - 1; i >= 0; --i) {
            if (!wordSeparator.contains(Character.valueOf(this.code.charAt(i)))) continue;
            startPos = i + 1;
            break;
        }
        if ((toScan = this.code.substring(startPos, this.offset)).trim().length() == 0) {
            for (int i = 0; i < this.emptyCompletion.length; ++i) {
                String item = this.emptyCompletion[i];
                suggestions.add(new UxCodeSuggestion(item, item));
            }
            return new UxCodeCompletion(suggestions);
        }
        this.getSuggestions(suggestions, toScan);
        return new UxCodeCompletion(suggestions);
    }

    private void getSuggestions(List<UxCodeSuggestion> suggestions, String toScan) {
        String upperQuery = toScan.toUpperCase();
        for (int i = 0; i < this.viewCodeCompl.length; ++i) {
            String code = this.viewCodeCompl[i];
            if (!code.toUpperCase().startsWith(upperQuery)) continue;
            suggestions.add(new UxCodeSuggestion(code.substring(upperQuery.length()), code));
        }
    }

    static {
        Arrays.sort(javaView);
        Arrays.sort(javaViewEmpty);
        Arrays.sort(simpleJavaView);
        Arrays.sort(simpleJavaViewEmpty);
        Arrays.sort(importStatement);
    }
}

