/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.code.queries;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletion;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionKind;
import crazydev.iccube.ux.builder.code.queries.UxCodeCompletionProvider;
import crazydev.iccube.ux.builder.code.queries.provider.UxCodeCompletionColumnDefs;
import crazydev.iccube.ux.builder.code.queries.provider.UxCodeCompletionEmpty;
import crazydev.iccube.ux.builder.code.queries.provider.UxCodeCompletionJava;
import crazydev.iccube.ux.builder.code.queries.provider.UxCodeCompletionJavascript;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxCodeCompletionQuery
extends UxBuilderQuery {
    private final UxCodeCompletionKind completionKind;
    private final int maxCount;
    private final String code;
    private final int offset;

    protected UxCodeCompletionQuery(UxQueryMeta meta, OlapRequestId requestId, UxCodeCompletionKind completionKind, int maxCount, String code, int offset) {
        super(meta, requestId);
        this.completionKind = completionKind;
        this.maxCount = maxCount;
        this.code = code;
        this.offset = offset;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxCodeCompletion completion = ((UxCodeCompletionProvider)(switch (this.completionKind) {
            case UxCodeCompletionKind.COLUMN_DEFS -> new UxCodeCompletionColumnDefs(this.completionKind, this.maxCount, this.code, this.offset);
            case UxCodeCompletionKind.JAVA_VIEW_IMPORT, UxCodeCompletionKind.JAVA_VIEW_CODE_SIMPLE, UxCodeCompletionKind.JAVA_VIEW_CODE -> new UxCodeCompletionJava(this.completionKind, this.maxCount, this.code, this.offset);
            case UxCodeCompletionKind.JS -> new UxCodeCompletionJavascript(this.completionKind, this.maxCount, this.code, this.offset);
            default -> new UxCodeCompletionEmpty();
        })).complete(queryContext);
        return UxReply.actionSuccess(completion);
    }
}

