/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.utils;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.file.UxFileReplyPayload;
import crazydev.iccube.ux.common.file.UxFileStatus;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.jetbrains.annotations.Nullable;

public abstract class UxFileUtils {
    private UxFileUtils() {
    }

    public static UxReply createFileContent(UxQueryContext queryContext, UxConsoleConstants.QueryName queryName, UxFileWrapper file) {
        return UxFileUtils.createFileContent(queryContext, queryName, file, null);
    }

    public static UxReply createFileContent(UxQueryContext queryContext, UxConsoleConstants.QueryName queryName, UxFileWrapper file, @Nullable UxAction save) {
        return UxFileUtils.createFileContent(queryContext, queryName, file, null, null, null, save);
    }

    public static UxReply createFileContent(UxQueryContext queryContext, UxConsoleConstants.QueryName queryName, UxFileWrapper file, @Nullable String additionalHelp, @Nullable UxAction completion, @Nullable Object completionUtils, @Nullable UxAction save) {
        UxReply uxReply;
        block10: {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            if (!file.exists()) {
                return UxReply.success(new UxFileReplyPayload(UxFileStatus.FILE_NOT_FOUND, babylon.translate(UxFileStatus.FILE_NOT_FOUND.tag(), new Serializable[]{file.getName()})));
            }
            Reader reader = file.createInputStreamReader(file.createInputStream());
            try {
                int maxLen = file.maxLen(queryContext);
                StringWriter buffer = new StringWriter();
                CdVFileSystem vfs = queryContext.getVfs();
                boolean truncated = vfs.copyForUI(reader, (Writer)buffer, maxLen);
                UxFileStatus status = truncated ? UxFileStatus.FILE_TRUNCATED : UxFileStatus.FILE_OK;
                String mode = file.getCodeMirrorMode();
                uxReply = UxReply.success(new UxFileReplyPayload(status, babylon.translate(status.tag(), new Serializable[0]), file.getAbsolutePath(), buffer.toString(), mode, additionalHelp, completion, completionUtils, save));
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    OlapLoggers.UX_REQUEST.error((Object)("[UX] " + queryName.name() + " error"), (Throwable)ex);
                    return UxReply.success(new UxFileReplyPayload(UxFileStatus.FILE_NOT_FOUND, babylon.translate(UxFileStatus.FILE_NOT_FOUND.tag(), new Serializable[]{file.getName()})));
                }
                catch (IOException ex) {
                    OlapLoggers.UX_REQUEST.error((Object)("[UX] " + queryName.name() + " error"), (Throwable)ex);
                    return UxReply.success(new UxFileReplyPayload(UxFileStatus.FILE_IO_ERROR, babylon.translate(UxFileStatus.FILE_IO_ERROR.tag(), new Serializable[]{ex.getMessage()})));
                }
            }
            reader.close();
        }
        return uxReply;
    }
}

