/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.users.UxAbstractUserQuery;
import crazydev.iccube.ux.admin.queries.users.UxSaveUserQueryMeta;
import crazydev.iccube.ux.admin.queries.users.UxUserQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxUserQuery
extends UxAbstractUserQuery {
    @Nullable
    private final String uuid;
    @Nullable
    private OlapUserDefinition user;

    public UxUserQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        OlapTenant tenant;
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_UNKNOWN, (Serializable[])new Serializable[]{""}));
        }
        IOlapAuthenticationService service = queryContext.getAuthenticationService();
        int revNumber = service.getRevisionNumber();
        this.user = service.getUserDefinitionByUUID(this.uuid);
        if (this.user == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        if (queryContext.isWithMultiTenant() && (tenant = queryContext.asRuntimeContext().getDirectoriesResolved().getTenant()) != null && !tenant.getName().equals(this.user.getTenant())) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        boolean requiredPassword = queryContext.isUserDefinitionWithPassword();
        if (!requiredPassword) {
            queryContext.setModelTypeSetupInfo("NOT_REQUIRED_PASSWORD"::equals);
        } else {
            queryContext.setModelTypeSetupInfo("OPTIONAL_PASSWORD"::equals);
        }
        UxModel model = queryContext.convertToUxModel(revNumber, this.user);
        UxAction save = UxSaveUserQueryMeta.createAction(queryContext, false, this.user.getUUID(), this.user.getName());
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxUserQueryMeta.createUseCase(queryContext, this.uuid, this.user != null ? this.user.getName() : null));
    }
}

