/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.ux.admin.queries.completion.UxCompleteQueryMeta;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionType;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.model.UxModelType;
import crazydev.iccube.ux.common.model.UxModelTypeSetupInfo;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.processor.UxBabylonService;
import org.jetbrains.annotations.Nullable;

public class UxUserDefinitionModelType
extends UxModelType<OlapUserDefinition> {
    public static final String NAME_READONLY = "NAME_READONLY";
    public static final String ROLES_READONLY = "ROLES_READONLY";
    public static final String OPTIONAL_PASSWORD = "OPTIONAL_PASSWORD";
    public static final String NOT_REQUIRED_PASSWORD = "NOT_REQUIRED_PASSWORD";

    protected UxUserDefinitionModelType() {
        super("userDefinition", OlapUserDefinition.class);
    }

    @Override
    protected void doSetupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable OlapUserDefinition model) {
        boolean requiredPassword;
        UxModelTypeSetupInfo setup = context.getModelTypeSetupInfo();
        UxBabylonService babylon = context.getUxBabylonService();
        this.addProperty(context, OlapUserDefinition.UUID, UxFieldTypes.STRING, false, true, true);
        this.addProperty(context, OlapUserDefinition.AVATAR, UxFieldTypes.AVATAR, true, true, false);
        boolean nameReadonly = setup != null && setup.is(NAME_READONLY);
        this.addProperty(context, OlapUserDefinition.NAME, UxFieldTypes.STRING, true, nameReadonly, true);
        boolean bl = requiredPassword = setup == null || !setup.is(NOT_REQUIRED_PASSWORD);
        if (requiredPassword) {
            boolean mandatoryPassword = setup == null || !setup.is(OPTIONAL_PASSWORD);
            this.addProperty(context, OlapUserDefinition.PASSWORD, UxFieldTypes.PASSWORD_HASH, true, false, mandatoryPassword);
            this.addProperty(context, OlapUserDefinition.PASSWORD_CONFIRM, UxFieldTypes.PASSWORD_HASH, true, false, mandatoryPassword);
        }
        boolean rolesReadOnly = setup != null && setup.is(ROLES_READONLY);
        this.addProperty(context, OlapUserDefinition.ROLES, UxFieldTypes.STRINGS, UxCompleteQueryMeta.createAction(context, UxCompletionType.role, new String[0]), true, true, rolesReadOnly, true);
        this.addProperty(context, OlapUserDefinition.LOCALE, UxFieldTypes.LOCALE(babylon), true, false, false);
        if (context.isWithMultiTenant()) {
            this.addProperty(context, OlapUserDefinition.TENANT, UxFieldTypes.STRING, UxCompleteQueryMeta.createAction(context, UxCompletionType.tenant, new String[0]), true, true, false, false);
        } else {
            this.addProperty(context, OlapUserDefinition.TENANT, UxFieldTypes.STRING, false, true, false);
        }
    }
}

