/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.users.UxAbstractUserQuery;
import crazydev.iccube.ux.admin.queries.users.UxUsersException;
import crazydev.iccube.ux.admin.queries.users.UxUsersHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public class UxSaveUsersFileQuery
extends UxAbstractUserQuery {
    @Nullable
    private final String fileContent;

    protected UxSaveUsersFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String fileContent) {
        super(meta, requestId);
        this.fileContent = fileContent;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (this.fileContent == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{"missing file content"}));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.fileContent.getBytes(StandardCharsets.UTF_8));
        try {
            UxUsersHelper.applyUserDefinitions(queryContext, in, "edited");
            return UxReply.actionSuccess();
        }
        catch (UxUsersException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] users deployment error", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{ex.getLocalizedMessage()}));
        }
    }
}

