/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.users;

import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.users.UxAbstractUserQuery;
import crazydev.iccube.ux.admin.queries.users.UxSaveUserQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxCreateUserQuery
extends UxAbstractUserQuery {
    public UxCreateUserQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        OlapUserDefinition user = new OlapUserDefinition().setupForEmptyModel();
        IOlapAuthenticationService service = queryContext.getAuthenticationService();
        int revNumber = service.getRevisionNumber();
        boolean requiredPassword = queryContext.isUserDefinitionWithPassword();
        if (!requiredPassword) {
            queryContext.setModelTypeSetupInfo("NOT_REQUIRED_PASSWORD"::equals);
        }
        UxModel model = queryContext.convertToUxModel(revNumber, user);
        UxAction save = UxSaveUserQueryMeta.createAction(queryContext, true, user.getUUID(), user.getName());
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.CreateUser));
    }
}

