/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.tenants;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.tenants.UxAbstractTenantQuery;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantsHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDeleteTenantQuery
extends UxAbstractTenantQuery {
    private final String uuid;

    public UxDeleteTenantQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (!queryContext.isSuperAdministrator()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
        try {
            if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
                return UxReply.actionSuccess();
            }
            UxValidationResult error = UxTenantsHelper.deleteTenantDefinition(queryContext, this.uuid);
            if (error != null) {
                return UxReply.validationErrors(error);
            }
            return UxReply.actionSuccess();
        }
        catch (OlapDirectoriesResolvedNotSuperAdminException ex) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
    }
}

