/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.partition;

import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapUnloadPartitionsHelper;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxUnloadPartitionsQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String schemaName;
    private final String dataSourceName;
    private final String dataTableName;
    private final List<String> partitions;
    private final int waitS;
    private final int cancelS;

    protected UxUnloadPartitionsQuery(UxQueryMeta meta, OlapRequestId requestId, String schemaName, String dataSourceName, String dataTableName, List<String> partitions, int waitS, int cancelS) {
        super(meta, requestId, (Integer)null);
        this.schemaName = schemaName;
        this.dataSourceName = dataSourceName;
        this.dataTableName = dataTableName;
        this.partitions = partitions;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    public boolean isMonitoredForTimeout() {
        return false;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.LOAD;
    }

    @Override
    public boolean isUnloadPartitions() {
        return true;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSchemaLifeCycleName() {
        return this.schemaName;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        boolean asRange = false;
        OlapEngineUnloadPartitionsParams params = new OlapEngineUnloadPartitionsParams(null, this.schemaName, this.dataSourceName, this.dataTableName, false, this.partitions, this.waitS, this.cancelS);
        OlapEngineRequestContext eContext = queryContext.getOlapEngineRequestContext();
        OlapUnloadPartitionsHelper helper = new OlapUnloadPartitionsHelper(eContext);
        OlapSchemaLifeCycleStatus status = helper.unloadPartitions(params);
        return UxReply.actionSuccess(new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus()));
    }
}

